<?php $v->layout('layouts/main', ['title' => 'Clientes']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Clientes</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Meus Clientes</h6>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="clients" class="table table-lg">
                        <thead>
                            <tr>
                                <th>#ID</th>
                                <th>Estabelecimento</th>
                                <th>Entregador</th>
                                <th>Preço</th>
                                <th>Status</th>
                                <th>Data</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>



<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };

    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#projects_e > a').addClass("active");
        $('div#projects').addClass("open");
        $('a#clientes').addClass("active");
        

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#clients').DataTable({
            "ajax": {
                "url": api + "clients",
                "type": 'GET',
                "headers": {'Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": "name"},
                {"defaultContent": "<a href='' type='button' class='text-secondary' data-toggle='tooltip' title='Editar'> <i class='ti-pencil'></i></a> <a href='' type='button' class='text-danger ml-2' data-toggle='tooltip' title='Deletar'> <i class='ti-trash'></i></a>"},
            ]
        });
    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>