<?php $v->layout('layouts/main', ['title' => 'Cupons']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Cupons</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Cupons</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadCupom">
                    <i class="fa fa-plus"></i> &nbsp; Novo Cupom
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="coupons" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Cupom</th>
                                <th>R$</th>
                                <th>%</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR CUPOM -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadCupom">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Cupom</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarCupom">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="name">Cupom</label>
                                <input type="text" class="form-control" name="name" placeholder="Cupom" maxlength="30">
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="value">Valor (R$)</label>
                                <input type="text" class="form-control value" name="value" placeholder="Valor em Reais" data-affixes-stay="false" data-thousands="." data-decimal="," maxlength="12">
                            </div>
                        </div>

                        <label for="value">ou</label>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="value">Valor (%)</label>
                                <input type="number" class="form-control" name="percentage" placeholder="Valor em Porcentagem" min="1" max="100" maxlength="3">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadCupom">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR CUPOM -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditCupom">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Cupom</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarCupom">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <input type="hidden" id="id_neighborhood">
                                <label for="name">Cupom</label>
                                <input type="text" class="form-control" name="name" placeholder="Cupom" maxlength="30" id="name_neighborhood">
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="value">Valor (R$)</label>
                                <input type="text" class="form-control value" name="value" placeholder="Valor em Reais" data-affixes-stay="false" data-thousands="." data-decimal="," maxlength="12" id="value_neighborhood">
                            </div>
                        </div>

                        <label for="value">ou</label>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="value">Valor (%)</label>
                                <input type="number" class="form-control" name="percentage" placeholder="Valor em Porcentagem" min="1" max="100" id="percentage_neighborhood" maxlength="3">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditCupom">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-maskmoney/3.0.2/jquery.maskMoney.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };

    // carregar a tabela de bairros
    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#apps_e > a').addClass("active");
        $('div#apps').addClass("open");
        $('a#cupons').addClass("active");
        

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#coupons').DataTable({
            "ajax": {
                "url": api + "coupons",
                "type": 'GET',
                "headers": {'Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": "name"},
                {"data": "value"},
                {"data": "percentage"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                },
            ]
        });
    });


    $(document).ready(function () {

        // mascara valor
        $(".value").maskMoney();


        // cadastrar o bairro
        $(document).on('click', '#btnCadCupom', function () {

            // get form data
            var form_data = $('#frmCadastrarCupom').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "coupons",
                type: 'POST',
                headers: {'Authorization': `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Cupom cadastrado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarCupom').trigger("reset");
                    $('#modalCadCupom').modal('hide');
                    $('#coupons').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditCupom').on('hidden.bs.modal', function () {
            $('#frmEditarCupom input').each(function () {
                $(this).val('');
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "coupons/" + item_id,
                type: 'GET',
                headers: {'Authorization': `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_neighborhood').val(data.id);
                    $('#name_neighborhood').val(data.name);
                    $('#value_neighborhood').val(data.value);
                    $('#percentage_neighborhood').val(data.percentage);

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditCupom').modal('show');
        });


        // editar o bairro
        $(document).on('click', '#btnEditCupom', function () {

            var id = $('#id_neighborhood').val();
            var form_data = $('#frmEditarCupom').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "coupons/" + id,
                type: 'PUT',
                headers: {'Authorization': `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Cupom alterado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarCupom').trigger("reset");
                    $('#modalEditCupom').modal('hide');
                    $('#coupons').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });



        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar este bairro?');
            if (confirmado) {

                $.ajax({
                    url: api + "coupons/" + item_id,
                    type: 'DELETE',
                    headers: {'Authorization': `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Cupom excluído com sucesso!',
                            timeout: 6000,
                        });

                        $('#coupons').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });
    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>