<?php $v->layout('layouts/main', ['title' => 'Gateway de Pagamento']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Gateway de Pagamento</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Gateway de Pagamento</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadGateway">
                    <i class="fa fa-plus"></i> &nbsp; Novo Gateway de Pagamento
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="gateways" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Gateway de Pagamento</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR GATEWAY DE PAGAMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadGateway">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Gateway de Pagamento</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarGateway">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Gateway de Pagamento</label>
                                <input type="text" class="form-control" name="name" placeholder="Gateway" maxlength="30">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">E-mail</label>
                                <input type="email" class="form-control" name="email" placeholder="Gateway de Pagamento" maxlength="70">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Token 1</label>
                                <input type="text" class="form-control" name="token_1" placeholder="Gateway de Pagamento" maxlength="200">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Token 2</label>
                                <input type="text" class="form-control" name="token_2" placeholder="Gateway de Pagamento" maxlength="200">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Aceitar Boleto?</label>
                                <select class="form-control"name="accept_slip" style="width: 100%;" required='required'>
                                    <option value="S">Sim</option>
                                    <option value="N">Não</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Url</label>
                                <input type="url" class="form-control" name="url" placeholder="Gateway de Pagamento" maxlength="70">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadGateway">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR GATEWAY DE PAGAMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditGateway">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Gateway de Pagamento</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarGateway">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" id="id_gateway">
                                <label for="name">Gateway de Pagamento</label>
                                <input type="text" class="form-control" name="name" placeholder="Gateway de Pagamento" maxlength="30" id="name_gateway">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">E-mail</label>
                                <input type="email" class="form-control" name="email" placeholder="Gateway de Pagamento" maxlength="70" id="email_gateway">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Token 1</label>
                                <input type="text" class="form-control" name="token_1" placeholder="Gateway de Pagamento" maxlength="200" id="token_1_gateway">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Token 2</label>
                                <input type="text" class="form-control" name="token_2" placeholder="Gateway de Pagamento" maxlength="200" id="token_2_gateway">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Aceitar Boleto?</label>
                                <select class="form-control"name="accept_slip" style="width: 100%;" required='required' id="accept_slip_gateway">
                                    <option value="S">Sim</option>
                                    <option value="N">Não</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Url</label>
                                <input type="url" class="form-control" name="url" placeholder="Gateway de Pagamento" maxlength="70" id="url_gateway">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditGateway">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"A"') {
            return logout();
        }
    };

    // carregar a tabela de Gateway de Pagamento
    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#analytics_a > a').addClass("active");
        $('div#analytics').addClass("open");
        $('a#gateway').addClass("active");
        

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#gateways').DataTable({
            "ajax": {
                "url": api + "gateways",
                "type": 'GET',
                "headers": {'X-Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": "name"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                },
            ]
        });
    });


    $(document).ready(function () {

        // cadastrar o gateway de pagamento
        $(document).on('click', '#btnCadGateway', function () {

            // get form data
            var form_data = $('#frmCadastrarGateway').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "gateways",
                type: 'POST',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Gateway de Pagamento cadastrado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarGateway').trigger("reset");
                    $('#modalCadGateway').modal('hide');
                    $('#gateways').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditGateway').on('hidden.bs.modal', function () {
            $('#frmEditarGateway input').each(function () {
                $(this).val('');
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "gateways/" + item_id,
                type: 'GET',
                headers: {"X-Authorization": `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_gateway').val(data.id);
                    $('#name_gateway').val(data.name);
                    $('#email_gateway').val(data.email);
                    $('#token_1_gateway').val(data.token_1);
                    $('#token_2_gateway').val(data.token_2);
                    $('#accept_slip_gateway').val(data.accept_slip);
                    $('#url_gateway').val(data.url);

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditGateway').modal('show');
        });


        // editar o gateway de pagamento
        $(document).on('click', '#btnEditGateway', function () {

            var id = $('#id_gateway').val();
            var form_data = $('#frmEditarGateway').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "gateways/" + id,
                type: 'PUT',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Gateway de Pagamento alterado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarGateway').trigger("reset");
                    $('#modalEditGateway').modal('hide');
                    $('#gateways').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar esta forma de gateway de pagamento?');
            if (confirmado) {

                $.ajax({
                    url: api + "gateways/" + item_id,
                    type: 'DELETE',
                    headers: {"X-Authorization": `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Gateway de Pagamento excluído com sucesso!',
                            timeout: 6000,
                        });

                        $('#gateways').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });
    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>