<?php require_once __DIR__ . "/../app/Helpers/counter.php"; ?>
<?php $v->layout('layouts/main', ['title' => 'Painel Administrativo']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item active">
                <a href="/dashboard">Dashboard</a>
            </li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="row">
            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Pedido</p>
                                <h2 class="font-weight-bold"><span id="order-counter">0</span></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-success-bright text-success rounded-circle">
                                        <i class="fas fa-shopping-cart"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Usuários</p>
                                <h2 class="font-weight-bold"><span id="user-counter">0</span></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-info-bright text-info rounded-circle">
                                        <i class="fas fa-users"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Entregadores</p>
                                <h2 class="font-weight-bold"><span id="courier-counter">0</span></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-secondary-bright text-secondary rounded-circle">
                                        <i class="fas fa-truck"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Estabelecimentos</p>
                                <h2 class="font-weight-bold"><?php echo getEstablishmentCount(); ?></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-warning-bright text-warning rounded-circle">
                                        <i class="fas fa-store"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>



        </div>

    </div>
</div>



<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Pedidos recentes</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2">
                    <i class="fa fa-refresh"></i>
                </a>
                <div class="dropdown">
                    <a href="#" data-toggle="dropdown"
                       class="btn btn-outline-light btn-sm"
                       aria-haspopup="true" aria-expanded="false">
                        <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item" href="#">Action</a>
                        <a class="dropdown-item" href="#">Another action</a>
                        <a class="dropdown-item" href="#">Something else here</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="recent-orders" class="table table-lg">
                        <thead>
                            <tr>
                                <th>#ID</th>
                                <th>Estabelecimento</th>
                                <th>Entregador</th>
                                <th>Preço</th>
                                <th>Status</th>
                                <th>Data</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <a href="#">3145</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product1.png"
                                             class="rounded mr-3" alt="grape">
                                        <span>HP Pavilion 15-EC0005NT AMD</span>
                                    </a>
                                </td>
                                <td>Dollie Bullock</td>
                                <td>$230</td>
                                <td>
                                    <span
                                        class="badge bg-secondary-bright text-secondary">On pre-order (not paid)</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <a href="#">7321</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product2.png"
                                             class="rounded mr-3" alt="banana">
                                        <span>Samsung Galaxy A51 128 GB</span>
                                    </a>
                                </td>
                                <td>Holmes Hines</td>
                                <td>$300</td>
                                <td>
                                    <span class="badge bg-success-bright text-success">Payment accepted</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <a href="#">9342</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product3.png"
                                             class="rounded mr-3" alt="cherry">
                                        <span>Snopy SN-BT96 Pretty</span>
                                    </a>
                                </td>
                                <td>Serena Glover</td>
                                <td>$250</td>
                                <td>
                                    <span class="badge bg-danger-bright text-danger">Payment error</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <a href="#">6416</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product4.png"
                                             class="rounded mr-3" alt="papaya">
                                        <span>Ultimate Ears Wonderboom</span>
                                    </a>
                                </td>
                                <td>Dianne Prince</td>
                                <td>$550</td>
                                <td>
                                    <span class="badge bg-success-bright text-success">Payment accepted</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <a href="#">92327</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product5.png"
                                             class="rounded mr-3" alt="pig">
                                        <span>Canon Pixma E3140 Printer</span>
                                    </a>
                                </td>
                                <td>Morgan Pitts</td>
                                <td>$280</td>
                                <td>
                                    <span class="badge bg-warning-bright text-warning">Preparing the order</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <a href="#">3013</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product6.png"
                                             class="rounded mr-3" alt="pineapple">
                                        <span>Canon 4000D 18-55 MM</span>
                                    </a>
                                </td>
                                <td>Merrill Richardson</td>
                                <td>$128</td>
                                <td>
                                    <span class="badge bg-info-bright text-info">Awaiting PayPal payment</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <a href="#">10323</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product7.png"
                                             class="rounded mr-3" alt="pomegranate">
                                        <span>Lenovo Tab E10 TB-X104F 32GB 10.1"</span>
                                    </a>
                                </td>
                                <td>Krista Mathis</td>
                                <td>$500</td>
                                <td>
                                    <span class="badge bg-secondary-bright text-secondary">Shipped</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <a href="#">4218</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product8.png"
                                             class="rounded mr-3" alt="raspberry">
                                        <span>Samsung 55Q60RAT 55"</span>
                                    </a>
                                </td>
                                <td>Frankie Hewitt</td>
                                <td>$300</td>
                                <td>
                                    <span class="badge bg-success-bright text-success">Remote payment accepted</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <a href="#">3158</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product9.png"
                                             class="rounded mr-3" alt="strawberry">
                                        <span>Toshiba Canvio Basic 1TB 2.5"</span>
                                    </a>
                                </td>
                                <td>Hayden Fitzgerald</td>
                                <td>$200</td>
                                <td>
                                    <span class="badge bg-success-bright text-success">Delivered</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <a href="#">9610</a>
                                </td>
                                <td>
                                    <a href="product-detail.html" class="d-flex align-items-center">
                                        <img width="40" src="assets/media/image/products/product10.png"
                                             class="rounded mr-3" alt="watermelon">
                                        <span>Fms Wireless Controller</span>
                                    </a>
                                </td>
                                <td>Cole Holcomb</td>
                                <td>$700</td>
                                <td>
                                    <span
                                        class="badge bg-secondary-bright text-secondary">On pre-order (not paid)</span>
                                </td>
                                <td>2018/08/28 21:24:36</td>
                                <td>
                                    <a href="#" class="text-secondary" data-toggle="tooltip" title="Edit">
                                        <i class="ti-pencil"></i>
                                    </a>
                                    <a href="#" class="text-danger ml-2" data-toggle="tooltip" title="Delete">
                                        <i class="ti-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>



<?php $v->start('scripts') ?>
<script src="assets/js/examples/pages/ecommerce-dashboard.js"></script>
<script src="apexcharts.com/samples/assets/irregular-data-series.js"></script>
<script src="vendors/charts/apex/apexcharts.min.js"></script>
<script src="vendors/dataTable/datatables.min.js"></script>
<?php include './config.php'; ?>
<?php $v->end() ?>
<script src="/update_all_counters.js"></script>
