<?php $v->layout('layouts/main', ['title' => 'Configurações']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }

    .imagePreview1, .imagePreview2, .imagePreview3 {
        width: 100%;
        height: 180px;
        background-position: center center;
        background-image: url('assets/media/image/not.png');
        background-color:#fff;
        background-size: cover;
        background-repeat:no-repeat;
        display: inline-block;
        box-shadow:0px -3px 6px 2px rgba(0,0,0,0.2);
    }
    .imgUp1, .imgUp2, .imgUp3
    {
        margin-bottom:15px;
    }
    .imgAdd
    {
        width:30px;
        height:30px;
        border-radius:50%;
        background-color:#4bd7ef;
        color:#fff;
        box-shadow:0px 0px 2px 1px rgba(0,0,0,0.2);
        text-align:center;
        line-height:30px;
        margin-top:0px;
        cursor:pointer;
        font-size:15px;
    }
    .btn{
        width: 100%;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Configurações</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Configurações</h6>
        </div>

        <div class="row">
            <div class="col-md-12">
                <form id="frmAlterarSenha" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group col-md-6">
                                    <label for='password'>Nova Senha</label>
                                    <input type="password" class="form-control password" name="password" required="">
                                    <label class="red msg1"></label>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for='password_confirmation'>Confirmar Nova Senha</label>
                                    <input type="password" class="form-control confpass" name="password_confirmation" required="">
                                    <label class="red msg2"></label>
                                </div>
                            </div>   
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <button type="button" class="btn btn-primary" id="btnCadConfig">Atualizar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
// retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };


    $(document).ready(function () {

        // editar o config
        $('.confpass').keyup(function (event) {

            data = $('.password').val();
            var len = data.length;

            if (len == 0) {
                $('.msg1').text("A Senha não pode ficar em branco");
                event.preventDefault();
            } else {
                $('.msg1').text('');
            }

            if ($('.password').val() != $('.confpass').val()) {
                $('.msg2').text("A Senha e a Confirmação de Senha não são iguais");
                event.preventDefault();
            } else {
                $('.msg2').text('');
            }

        });



        $(document).on('click', '#btnCadConfig', function () {

            var id = JSON.parse(sessionStorage.getItem('Id'));
            var api = '<?php echo API; ?>';
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var form = $('#frmAlterarSenha').serialize();
            
            $.ajax({
                url: api + "alter-password/" + id,
                type: 'POST',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Senha alterada com sucesso!',
                        timeout: 6000,
                    });
                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');
                    
                    iziToast.error({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Error no preenchimento das senhas.',
                        timeout: 4000,
                    });

                }
            });
        });



        $(window).on('load', function () {

            var id = JSON.parse(sessionStorage.getItem('Id'));
            var api = '<?php echo API; ?>';
            var img = '<?php echo IMG; ?>';
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

            // carregar dados
            $.ajax({
                url: api + "configuration/" + id,
                type: 'GET',
                headers: {"X-Authorization": `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('.imagePreview1').css("background-image", "url(" + img + data.tenant_id + '/favicon.jpg' + "),url(assets/media/image/not.png)");
                    $('.imagePreview2').css("background-image", "url(" + img + data.tenant_id + '/logo.jpg' + "),url(assets/media/image/not.png)");
                    $('.imagePreview3').css("background-image", "url(" + img + data.tenant_id + '/logo2.jpg' + "),url(assets/media/image/not.png)");

                    $('#color').val(data.color);
                    $('#title').val(data.title);
                    $('#description').val(data.description);
                    $('#keywords').val(data.keywords);
                    $('#facebook').val(data.facebook);
                    $('#instagram').val(data.instagram);
                    $('#whatsapp').val(data.whatsapp);
                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });


        });
    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>