<?php $v->layout('layouts/main', ['title' => 'Configurações']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }

    .imagePreview1, .imagePreview2, .imagePreview3 {
        width: 100%;
        height: 180px;
        background-position: center center;
        background-image: url('assets/media/image/not.png');
        background-color:#fff;
        background-size: cover;
        background-repeat:no-repeat;
        display: inline-block;
        box-shadow:0px -3px 6px 2px rgba(0,0,0,0.2);
    }
    .imgUp1, .imgUp2, .imgUp3
    {
        margin-bottom:15px;
    }
    .imgAdd
    {
        width:30px;
        height:30px;
        border-radius:50%;
        background-color:#4bd7ef;
        color:#fff;
        box-shadow:0px 0px 2px 1px rgba(0,0,0,0.2);
        text-align:center;
        line-height:30px;
        margin-top:0px;
        cursor:pointer;
        font-size:15px;
    }
    .btn{
        width: 100%;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Configurações</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Configurações</h6>
        </div>

        <div class="row">
            <div class="col-md-12">
                <form id="frmEditConfig" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-sm-4 imgUp1">
                                        <div class="imagePreview1"></div>
                                        <label class="btn btn-primary">
                                            Ícone<input type="file" class="uploadFile1 img" value="Ícone" style="width: 0px;height: 0px;overflow: hidden;" name="favicon" accept="image/*">
                                        </label>
                                    </div>

                                    <div class="col-sm-4 imgUp2">
                                        <div class="imagePreview2"></div>
                                        <label class="btn btn-primary">
                                            Logo 1<input type="file" class="uploadFile2 img" value="Logo 1" style="width: 0px;height: 0px;overflow: hidden;" name="logo" accept="image/*">
                                        </label>
                                    </div>

                                    <div class="col-sm-4 imgUp3">
                                        <div class="imagePreview3"></div>
                                        <label class="btn btn-primary">
                                            Logo 2<input type="file" class="uploadFile3 img" value="Logo 2" style="width: 0px;height: 0px;overflow: hidden;" name="logo2" accept="image/*">
                                        </label>
                                    </div>
                                </div>
                            </div>                              

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="color">Cor</label>
                                    <input type="color" class="form-control" name="color" id="color">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="title">Título</label>
                                    <input type="text" class="form-control" name="title" maxlength="50" id="title">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="description">Descrição</label>
                                    <input type="text" class="form-control" name="description" maxlength="200" id="description">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="keywords">Palavras Chave</label>
                                    <input type="text" class="form-control" name="keywords" maxlength="200" id="keywords">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="facebook">Facebook</label>
                                    <input type="text" class="form-control" name="facebook" maxlength="100" id="facebook">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="instagram">Instagram</label>
                                    <input type="text" class="form-control" name="instagram" maxlength="100" id="instagram">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="whatsapp">Whatsapp</label>
                                    <input type="text" class="form-control" name="whatsapp" maxlength="100" id="whatsapp">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <button type="button" class="btn btn-primary" id="btnCadConfig">Atualizar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };

    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#components_e > a').addClass("active");
        $('div#components').addClass("open");
        $('a#configuracoes').addClass("active");
        

        var id = JSON.parse(sessionStorage.getItem('Id'));
        var api = '<?php echo API; ?>';
        var img = '<?php echo IMG; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        // carregar dados
        $.ajax({
            url: api + "configuration/" + id,
            type: 'GET',
            headers: {'Authorization': `Bearer ${token}`},
            success: function (data) {
                var data = JSON.parse(JSON.stringify(data));

                $('.imagePreview1').css("background-image", "url(" + img + data.tenant_id + '/favicon.jpg' + "),url(assets/media/image/not.png)");
                $('.imagePreview2').css("background-image", "url(" + img + data.tenant_id + '/logo.jpg' + "),url(assets/media/image/not.png)");
                $('.imagePreview3').css("background-image", "url(" + img + data.tenant_id + '/logo2.jpg' + "),url(assets/media/image/not.png)");

                $('#color').val(data.color);
                $('#title').val(data.title);
                $('#description').val(data.description);
                $('#keywords').val(data.keywords);
                $('#facebook').val(data.facebook);
                $('#instagram').val(data.instagram);
                $('#whatsapp').val(data.whatsapp);
            },
            error: function (xhr, resp, text) {
                console.log('deu ruim');

            }
        });


    });


    $(document).ready(function () {

        // editar o config
        $(document).on('click', '#btnCadConfig', function () {

            var id = JSON.parse(sessionStorage.getItem('Id'));
            var form = new FormData($('#frmEditConfig')[0]);
//            var form = $('#frmEditConfig').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "configuration/" + id + '/editar',
                type: 'POST',
                enctype: 'multipart/form-data',
                headers: {'Authorization': `Bearer ${token}`},
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Configurações atualizadas com sucesso!',
                        timeout: 6000,
                    });
                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });
    });





    $(function () {
        $(document).on("change", ".uploadFile1", function ()
        {
            var uploadFile1 = $(this);
            var files = !!this.files ? this.files : [];
            if (!files.length || !window.FileReader)
                return; // no file selected, or no FileReader support

            if (/^image/.test(files[0].type)) { // only image file
                var reader = new FileReader(); // instance of the FileReader
                reader.readAsDataURL(files[0]); // read the local file

                reader.onloadend = function () { // set image data as background of div
                    //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                    uploadFile1.closest(".imgUp1").find('.imagePreview1').css("background-image", "url(" + this.result + ")");
                }
            }

        });

        $(document).on("change", ".uploadFile2", function ()
        {
            var uploadFile2 = $(this);
            var files = !!this.files ? this.files : [];
            if (!files.length || !window.FileReader)
                return; // no file selected, or no FileReader support

            if (/^image/.test(files[0].type)) { // only image file
                var reader = new FileReader(); // instance of the FileReader
                reader.readAsDataURL(files[0]); // read the local file

                reader.onloadend = function () { // set image data as background of div
                    //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                    uploadFile2.closest(".imgUp2").find('.imagePreview2').css("background-image", "url(" + this.result + ")");
                }
            }

        });

        $(document).on("change", ".uploadFile3", function ()
        {
            var uploadFile3 = $(this);
            var files = !!this.files ? this.files : [];
            if (!files.length || !window.FileReader)
                return; // no file selected, or no FileReader support

            if (/^image/.test(files[0].type)) { // only image file
                var reader = new FileReader(); // instance of the FileReader
                reader.readAsDataURL(files[0]); // read the local file

                reader.onloadend = function () { // set image data as background of div
                    //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                    uploadFile3.closest(".imgUp3").find('.imagePreview3').css("background-image", "url(" + this.result + ")");
                }
            }

        });
    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>