<?php $v->layout('layouts/main', ['title' => 'Estabelecimentos']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Estabelecimentos</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Estabelecimentos</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadEstabelecimento">
                    <i class="fa fa-plus"></i> &nbsp; Novo Estabelecimento
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="establishments" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Estabelecimento</th>
                                <th>Telefone</th>
                                <th>Bairro</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR ESTABELECIMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadEstabelecimento">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Estabelecimento</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarEstabelecimento">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="cpf_cnpj">CNPJ/CPF</label>
                                <input type="text" class="form-control cpf_cnpj" name="cpf_cnpj" placeholder="CNPJ/CPF" onkeypress='mascaraMutuario(this, cpfCnpj)' onblur='clearTimeout()' required="" maxlength="18">
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="name">Estabelecimento</label>
                                <input type="text" class="form-control name" name="name" placeholder="Estabelecimento" maxlength="100">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="segments">Segmento</label>
                                <select class="form-control segments" style="height: 70px;" name="segment_id[]" style="width: 100%;" required='required' multiple="multiple">
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="phone1">Telefone Comercial</label>
                                <input type="text" class="form-control phone" name="phone" placeholder="Telefone 1" maxlength="15">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="phone2">Celular</label>
                                <input type="text" class="form-control mobile" name="mobile" placeholder="Telefone 2" maxlength="15">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email">E-mail</label>
                                <input type="text" class="form-control" name="email" placeholder="E-mail" maxlength="70">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="cep">Cep</label>
                                <input type="text" class="form-control cep" name="cep" placeholder="Cep" maxlength="8">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="state">Estado</label>
                                <input type="text" class="form-control state" name="state" placeholder="Estado" maxlength="2">
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="form-group">
                                <label for="city">Cidade</label>
                                <input type="text" class="form-control city" name="city" placeholder="Cidade" maxlength="40">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="neighborhood">Bairro</label>
                                <input type="text" class="form-control neighborhood" name="neighborhood" placeholder="Bairro" maxlength="40">
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="street">Logradouro</label>
                                <input type="text" class="form-control street" name="street" placeholder="Logradouro" maxlength="120">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="number">Número</label>
                                <input type="number" class="form-control number" name="number" placeholder="Número" maxlength="8">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="complement">Complemento</label>
                                <input type="text" class="form-control complement" name="complement" placeholder="Complemento" maxlength="30">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="reference">Referência</label>
                                <input type="text" class="form-control" name="reference" placeholder="Referência" maxlength="150">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label style="color: red">*Informar ao estabelecimento a Senha Padrão: <strong>123456</strong> e o E-mail</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadEstabelecimento">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR ESTABELECIMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditEstabelecimento">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Estabelecimento</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarEstabelecimento">
                <div class="modal-body">
                    <div class="row">                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <input type="hidden" id="id_establishment">
                                <label for="cpf_cnpj">CNPJ/CPF</label>
                                <input type="text" class="form-control cpf_cnpj" name="cpf_cnpj" placeholder="CNPJ/CPF" id="cpf_cnpj_establishment" onkeypress='mascaraMutuario(this, cpfCnpj)' onblur='clearTimeout()' required="" maxlength="18">
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="name">Estabelecimento</label>
                                <input type="text" class="form-control name" name="name" placeholder="Estabelecimento" maxlength="100" id="name_establishment">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="segments">Segmento</label>
                                <select class="form-control segments" style="height: 70px;" name="segment_id[]" id="segment_id" style="width: 100%;" required='required' multiple="multiple">
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="phone1">Telefone Comercial</label>
                                <input type="text" class="form-control phone" name="phone" placeholder="Telefone 1" maxlength="15" id="phone_establishment">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="phone2">Celular</label>
                                <input type="text" class="form-control mobile" name="mobile" placeholder="Telefone 2" maxlength="15" id="mobile_establishment">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="email">E-mail</label>
                                <input type="text" class="form-control" name="email" placeholder="E-mail" maxlength="70" id="email_establishment">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="cep">Cep</label>
                                <input type="text" class="form-control cep" name="cep" placeholder="Cep" maxlength="8" id="cep_establishment">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="state">Estado</label>
                                <input type="text" class="form-control state" name="state" placeholder="Estado" maxlength="2" id="state_establishment">
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="form-group">
                                <label for="city">Cidade</label>
                                <input type="text" class="form-control city" name="city" placeholder="Cidade" maxlength="40" id="city_establishment">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="neighborhood">Bairro</label>
                                <input type="text" class="form-control neighborhood" name="neighborhood" placeholder="Bairro" maxlength="40" id="neighborhood_establishment">
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="form-group">
                                <label for="street">Logradouro</label>
                                <input type="text" class="form-control street" name="street" placeholder="Logradouro" maxlength="120" id="street_establishment">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="number">Número</label>
                                <input type="number" class="form-control number" name="number" placeholder="Número" maxlength="8" id="number_establishment">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="complement">Complemento</label>
                                <input type="text" class="form-control complement" name="complement" placeholder="Complemento" maxlength="30" id="complement_establishment">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="reference">Referência</label>
                                <input type="text" class="form-control" name="reference" placeholder="Referência" maxlength="150" id="reference_establishment">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditEstabelecimento">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script src="assets/js/jquery.maskedinput.min.js"></script>
<script>
                                    // retorna para o login se não tiver acesso a essa página
                                    window.onload = function () {
                                        var data = sessionStorage.getItem('Me');
                                        if (data != '"A"') {
                                            return logout();
                                        }
                                    };

                                    // carregar a tabela de pagamentos
                                    $(window).on('load', function () {
                                        
                                        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#analytics_a > a').addClass("active");
        $('div#analytics').addClass("open");
        $('a#estabelecimentos').addClass("active");

                                        var api = '<?php echo API; ?>';
                                        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

                                        $('#establishments').DataTable({
                                            "ajax": {
                                                "url": api + "establishments",
                                                "type": 'GET',
                                                "headers": {'X-Authorization': `Bearer ${token}`},
                                                "dataSrc": ""
                                            },
                                            "columns": [
                                                {"data": "name"},
                                                {"data": "phone"},
                                                {"data": "neighborhood"},
                                                {"data": 'id',
                                                    "render": function (data, type, row, meta) {
                                                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                                                    }
                                                },
                                            ]
                                        });

                                        // carregar select na modal
                                        selectSegmento();
                                    });


                                    $(document).ready(function () {

                                        $('.phone').mask('(99) 9999-9999');
                                        $('.mobile').mask('(99) 9999-99999');
                                        $('.cep').mask('99999-999');

                                        // cadastrar o pagamento
                                        $(document).on('click', '#btnCadEstabelecimento', function () {

                                            // get form data
                                            var form_data = $('#frmCadastrarEstabelecimento').serialize();
                                            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
                                            var api = '<?php echo API; ?>';

                                            // submit form data to api
                                            $.ajax({
                                                url: api + "establishments",
                                                type: 'POST',
                                                headers: {"X-Authorization": `Bearer ${token}`},
                                                data: form_data,
                                                success: function (data) {
                                                    var data = JSON.parse(JSON.stringify(data));
                                                    iziToast.success({
                                                        position: 'bottomRight',
                                                        title: 'OK',
                                                        message: 'Estabelecimento cadastrado com sucesso!',
                                                        timeout: 6000,
                                                    });

                                                    $('#frmCadastrarEstabelecimento').trigger("reset");
                                                    $('#modalCadEstabelecimento').modal('hide');
                                                    $('#establishments').DataTable().ajax.reload();

                                                },
                                                error: function (xhr, resp, text) {
                                                    console.log('deu ruim');

                                                }
                                            });
                                        });


                                        // limpar a modal ao fechar
                                        $('#modalEditEstabelecimento').on('hidden.bs.modal', function () {
                                            $('#frmEditarEstabelecimento input').each(function () {
                                                $(this).val('');
                                            });
                                        });


                                        // carregar o item na modal edit
                                        $(document).on('click', '[name="editItem"]', function (e) {
                                            e.preventDefault();

                                            var item_id = $(this).data('item_id');
                                            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
                                            var api = '<?php echo API; ?>';

                                            // carregar select na modal
                                            selectSegmento();

                                            setTimeout(function () {

                                                // submit form data to api
                                                $.ajax({
                                                    url: api + "establishments/" + item_id,
                                                    type: 'GET',
                                                    headers: {"X-Authorization": `Bearer ${token}`},
                                                    success: function (data) {
                                                        var data = JSON.parse(JSON.stringify(data));

                                                        $('#id_establishment').val(data.id);
                                                        $('#cpf_cnpj_establishment').val(data.cpf_cnpj);
                                                        $('#name_establishment').val(data.name);
                                                        $('#phone_establishment').val(data.phone);
                                                        $('#mobile_establishment').val(data.mobile);
                                                        $('#email_establishment').val(data.email);
                                                        $('#cep_establishment').val(data.cep);
                                                        $('#state_establishment').val(data.state);
                                                        $('#city_establishment').val(data.city);
                                                        $('#neighborhood_establishment').val(data.neighborhood);
                                                        $('#street_establishment').val(data.street);
                                                        $('#number_establishment').val(data.number);
                                                        $('#complement_establishment').val(data.complement);
                                                        $('#reference_establishment').val(data.reference);
                                                        $('#segment_id').val(data.segments);

                                                    },
                                                    error: function (xhr, resp, text) {
                                                        console.log('deu ruim');

                                                    }
                                                });

                                            }, 1000);

                                            $('#modalEditEstabelecimento').modal('show');
                                        });


                                        // editar o pagamento
                                        $(document).on('click', '#btnEditEstabelecimento', function () {

                                            var id = $('#id_establishment').val();
                                            var form_data = $('#frmEditarEstabelecimento').serialize();
                                            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
                                            var api = '<?php echo API; ?>';

                                            // submit form data to api
                                            $.ajax({
                                                url: api + "establishments/" + id,
                                                type: 'PUT',
                                                headers: {"X-Authorization": `Bearer ${token}`},
                                                data: form_data,
                                                success: function (data) {
                                                    var data = JSON.parse(JSON.stringify(data));
                                                    iziToast.success({
                                                        position: 'bottomRight',
                                                        title: 'OK',
                                                        message: 'Estabelecimento alterado com sucesso!',
                                                        timeout: 6000,
                                                    });

                                                    $('#frmEditarEstabelecimento').trigger("reset");
                                                    $('#modalEditEstabelecimento').modal('hide');
                                                    $('#establishments').DataTable().ajax.reload();

                                                },
                                                error: function (xhr, resp, text) {
                                                    console.log('deu ruim');

                                                }
                                            });
                                        });


                                        // deletar item
                                        $(document).on('click', '[name="deleteItem"]', function (e) {
                                            e.preventDefault();

                                            var item_id = $(this).data('item_id');
                                            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
                                            var api = '<?php echo API; ?>';

                                            var confirmado = confirm('Deseja realmente deletar esta forma de pagamento?');
                                            if (confirmado) {

                                                $.ajax({
                                                    url: api + "establishments/" + item_id,
                                                    type: 'DELETE',
                                                    headers: {"X-Authorization": `Bearer ${token}`},
                                                    success: function (data) {

                                                        iziToast.success({
                                                            position: 'bottomRight',
                                                            title: 'OK',
                                                            message: 'Estabelecimento excluído com sucesso!',
                                                            timeout: 6000,
                                                        });

                                                        $('#establishments').DataTable().ajax.reload();

                                                    },
                                                    error: function (xhr, resp, text) {
                                                        console.log('deu ruim');

                                                    }
                                                });

                                            } else {
                                                return false;
                                            }

                                        });



                                        //----------------- busca CEP --------------------------
                                        $(".cep").blur(function () {
                                            cep = $(this).val();
                                            cep = cep.replace('-', '');
                                            buscarCep(cep);
                                        });

                                        //----------------- busca cnpj --------------------------
                                        $(".cpf_cnpj").focusout(function (e) {

                                            // Apesar do botão estar com o type="button", é prudente chamar essa função para evitar algum comportamento indesejado
                                            e.preventDefault();

                                            // Aqui recuperamos o cnpj preenchido do campo e usamos uma expressão regular para limpar da string tudo aquilo que for diferente de números
                                            var cnpj = $('.cpf_cnpj').val().replace(/[^0-9]/g, '');

                                            // Fazemos uma verificação simples do cnpj confirmando se ele tem 14 caracteres
                                            if (cnpj.length === 14) {

                                                // Aqui rodamos o ajax para a url da API concatenando o número do CNPJ na url
                                                $.ajax({
                                                    url: 'https://www.receitaws.com.br/v1/cnpj/' + cnpj,
                                                    method: 'GET',
                                                    dataType: 'jsonp', // Em requisições AJAX para outro domínio é necessário usar o formato "jsonp" que é o único aceito pelos navegadores por questão de segurança
                                                    complete: function (xhr) {

                                                        // Aqui recuperamos o json retornado
                                                        response = xhr.responseJSON;

                                                        // Na documentação desta API tem esse campo status que retorna "OK" caso a consulta tenha sido efetuada com sucesso
                                                        if (response.status === 'OK') {

                                                            // Agora preenchemos os campos com os valores retornados
                                                            $('.name').val(response.nome);
                                                            $('.cep').val(response.cep.replace('.', ''));
                                                            $('.street').val(response.logradouro);
                                                            $('.number').val(response.numero);
                                                            $('.complement').val(response.complemento);
                                                            $('.city').val(response.municipio);
                                                            $('.state').val(response.uf);
                                                            $('.neighborhood').val(response.bairro);

                                                            // Aqui exibimos uma mensagem caso tenha ocorrido algum erro
                                                        } else {
                                                            iziToast.error({
                                                                title: 'Atenção!',
                                                                message: 'CNPJ não encontrado!',
                                                                position: 'center',
                                                                timeout: 4000,
                                                            });
                                                            $(".cpf_cnpj").val('').focus();
                                                        }
                                                    }
                                                });


                                            } else if (cnpj === "") {
                                                // Tratativa para caso não digite nada no campo.

                                            } else {
                                                // Tratativa para caso o CNPJ não tenha 14 ou seja inválido
                                            }
                                        });

                                    });

                                    function buscarCep(cep) {
                                        if (cep == "") {
//        $("#cep").focus();
                                            iziToast.warning({
                                                title: 'Atenção!',
                                                message: 'Digite um CEP válido!',
                                                position: 'center',
                                                timeout: 4000,
                                                icon: 'error'
                                            });
                                            return;
                                        }
                                        $.ajax({
                                            type: 'GET',
                                            dataType: 'jsonp',
                                            url: 'https://viacep.com.br/ws/' + cep + '/json/',
                                            async: true,
                                            success: function (data) {
                                                $(".street").val(data["logradouro"]);
                                                $(".neighborhood").val(data["bairro"]);
                                                $(".state").val(data["uf"]);
                                                $(".city").val(data["localidade"]);

                                                $(".number").focus();
                                            },
                                            error: function (data) {
                                                iziToast.error({
                                                    title: 'Atenção!',
                                                    message: 'CEP não encontrado!',
                                                    position: 'center',
                                                    timeout: 4000,
                                                });

                                                $(".street").val('');
                                                $(".neighborhood").val('');
                                                $(".state").val('');
                                                $(".city").val('');
                                                $(".number").val('');
                                                $(".complement").val('');

                                                //$(".cep").focus();
                                            }
                                        });
                                    }



                                    //----------------- Mascara CPF CNPJ --------------------------
                                    function mascaraMutuario(o, f) {
                                        v_obj = o
                                        v_fun = f
                                        setTimeout('execmascara()', 1)
                                    }

                                    function execmascara() {
                                        v_obj.value = v_fun(v_obj.value)
                                    }

                                    function cpfCnpj(v) {

                                        //Remove tudo o que não é dígito
                                        v = v.replace(/\D/g, "")

                                        if (v.length <= 11) { //CPF

                                            //Coloca um ponto entre o terceiro e o quarto dígitos
                                            v = v.replace(/(\d{3})(\d)/, "$1.$2")

                                            //Coloca um ponto entre o terceiro e o quarto dígitos
                                            //de novo (para o segundo bloco de números)
                                            v = v.replace(/(\d{3})(\d)/, "$1.$2")

                                            //Coloca um hífen entre o terceiro e o quarto dígitos
                                            v = v.replace(/(\d{3})(\d{1,2})$/, "$1-$2")

                                        } else { //CNPJ

                                            //Coloca ponto entre o segundo e o terceiro dígitos
                                            v = v.replace(/^(\d{2})(\d)/, "$1.$2")

                                            //Coloca ponto entre o quinto e o sexto dígitos
                                            v = v.replace(/^(\d{2})\.(\d{3})(\d)/, "$1.$2.$3")

                                            //Coloca uma barra entre o oitavo e o nono dígitos
                                            v = v.replace(/\.(\d{3})(\d)/, ".$1/$2")

                                            //Coloca um hífen depois do bloco de quatro dígitos
                                            v = v.replace(/(\d{4})(\d)/, "$1-$2")

                                        }

                                        return v

                                    }


                                    // select
                                    function selectSegmento()
                                    {
                                        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
                                        var api = '<?php echo API; ?>';

                                        $.ajax({
                                            type: 'GET',
                                            url: api + "segments",
                                            headers: {"X-Authorization": `Bearer ${token}`},
                                            success: function (data) {
                                                segmentos = JSON.parse(JSON.stringify(data));

                                                $(".segments").html('');
                                                $.each(segmentos, function (i, segmento) {
                                                    $(".segments").append($('<option>', {
                                                        value: segmento.id, //Id do objeto segmento
                                                        text: segmento.name //Nome do segmento
                                                    }));
                                                });
                                            }
                                        });
                                    }

</script>
<?php include './config.php'; ?>
<?php $v->end() ?>