<?php $v->layout('layouts/main', ['title' => 'Produtos']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }

    .imagePreview {
        width: 100%;
        height: 180px;
        background-position: center center;
        background-image: url('assets/media/image/not.png');
        background-color:#fff;
        background-size: cover;
        background-repeat:no-repeat;
        display: inline-block;
        box-shadow:0px -3px 6px 2px rgba(0,0,0,0.2);
    }
    .imgUp
    {
        margin-bottom:15px;
    }
    .imgAdd
    {
        width:30px;
        height:30px;
        border-radius:50%;
        background-color:#4bd7ef;
        color:#fff;
        box-shadow:0px 0px 2px 1px rgba(0,0,0,0.2);
        text-align:center;
        line-height:30px;
        margin-top:0px;
        cursor:pointer;
        font-size:15px;
    }
    .btn{
        width: 100%;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Produtos</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Produtos</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadProduto">
                    <i class="fa fa-plus"></i> &nbsp; Novo Produto
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="products" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Produto</th>
                                <th>Quantidade</th>
                                <th>Preço</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR PRODUTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadProduto">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Produto</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarProduto" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-sm-6 offset-md-3 imgUp">
                                    <div class="imagePreview"></div>
                                    <label class="btn btn-primary">
                                        Foto<input type="file" class="uploadFile img" value="Foto" style="width: 0px;height: 0px;overflow: hidden;" name="image" accept="image/*">
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Produto</label>
                                <input type="text" class="form-control" name="name" placeholder="Produto" maxlength="30">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="code">Código</label>
                                <input type="text" class="form-control" name="code" placeholder="Produto" maxlength="50">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="quantity">Quantidade</label>
                                <input type="number" class="form-control" name="quantity" placeholder="Produto" min="1">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="price">Preço</label>
                                <input type="text" class="form-control value" name="price" placeholder="Produto" data-affixes-stay="false" data-thousands="." data-decimal="," maxlength="12">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id">Categoria</label>
                                <select class="form-control categorias category_id" name="category_id"></select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id">Subcategoria</label>
                                <select class="form-control subcategorias" name="subcategory_id"></select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="observation">Observação</label>
                                <input type="text" class="form-control" name="observation" placeholder="Produto" maxlength="100">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadProduto">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR PRODUTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditProduto">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Produto</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarProduto" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-sm-6 offset-md-3 imgUp">
                                    <div class="imagePreview"></div>
                                    <label class="btn btn-primary">
                                        Foto<input type="file" class="uploadFile img" value="Foto" style="width: 0px;height: 0px;overflow: hidden;" name="image" accept="image/*">
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" id="id_payment">
                                <label for="name">Produto</label>
                                <input type="text" class="form-control" name="name" placeholder="Produto" maxlength="30" id="name_payment">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="code">Código</label>
                                <input type="text" class="form-control" name="code" placeholder="Código" maxlength="50" id="code_payment">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="quantity">Quantidade</label>
                                <input type="number" class="form-control" name="quantity" placeholder="Quantidade" min="1" id="quantity_payment">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="price">Preço</label>
                                <input type="text" class="form-control value" name="price" placeholder="Preço" data-affixes-stay="false" data-thousands="." data-decimal="," maxlength="12" id="price_payment">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id">Categoria</label>
                                <select class="form-control categorias" name="category_id" id="category_payment"></select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="subcategory_id">Subcategoria</label>
                                <select class="form-control subcategorias" name="subcategory_id" id="subcategory_payment"></select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="observation">Observação</label>
                                <input type="text" class="form-control" name="observation" placeholder="Descrição" maxlength="100" id="observation_payment">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditProduto">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-maskmoney/3.0.2/jquery.maskMoney.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };

    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#components_e > a').addClass("active");
        $('div#components').addClass("open");
        $('a#produtos').addClass("active");
        
        

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        // carregar a tabela de produtos
        $('#products').DataTable({
            "ajax": {
                "url": api + "products",
                "type": 'GET',
                "headers": {'X-Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": "name"},
                {"data": "quantity"},
                {"data": "price"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                }
            ]
        });

        // carregar select na modal
        selectCategory();
    });


    $(document).ready(function () {

        // mascara valor
        $(".value").maskMoney();

        // cadastrar o produto
        $(document).on('click', '#btnCadProduto', function () {

            var form = new FormData($('#frmCadastrarProduto')[0]);
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "products",
                type: 'POST',
                enctype: 'multipart/form-data',
                headers: {'X-Authorization': `Bearer ${token}`},
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Produto cadastrado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarProduto').trigger("reset");
                    $('#modalCadProduto').modal('hide');
                    $('#products').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditProduto').on('hidden.bs.modal', function () {
            $('#frmEditarProduto input').each(function () {
                $(this).val('');
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';
            var img = '<?php echo IMG; ?>';

            // carregar select na modal
            selectCategory();

            // submit form data to api
            $.ajax({
                url: api + "products/" + item_id,
                type: 'GET',
                headers: {'X-Authorization': `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_payment').val(data.id);
                    $('#name_payment').val(data.name);
                    $('#code_payment').val(data.code);
                    $('#quantity_payment').val(data.quantity);
                    $('#price_payment').val(data.price);
                    $('#category_payment').val(data.category_id);
                    $('#observation_payment').val(data.observation);
                    $('.imagePreview').css("background-image", "url(" + img + data.tenant_id + '/produtos/' + data.id + '.jpg' + "),url(assets/media/image/not.png)");
                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditProduto').modal('show');
        });


        // editar o produto
        $(document).on('click', '#btnEditProduto', function () {

            var id = $('#id_payment').val();
            var form = new FormData($('#frmEditarProduto')[0]);
//            var form = $('#frmEditarProduto').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "products/" + id + '/editar',
                type: 'POST',
                enctype: 'multipart/form-data',
                headers: {'X-Authorization': `Bearer ${token}`},
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Produto alterado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarProduto').trigger("reset");
                    $('#modalEditProduto').modal('hide');
                    $('#products').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar esta forma de produto?');
            if (confirmado) {

                $.ajax({
                    url: api + "products/" + item_id,
                    type: 'DELETE',
                    headers: {'X-Authorization': `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Produto excluído com sucesso!',
                            timeout: 6000,
                        });

                        $('#products').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });










        $('.category_id').change(function () {
            var category_id = $('.category_id option:selected').val();
            selectSubCategory(category_id);
        });
        
    });

    function selectCategory()
    {
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
        var api = '<?php echo API; ?>';

        $.ajax({
            type: 'GET',
            url: api + "categories",
            headers: {'X-Authorization': `Bearer ${token}`},
            success: function (data) {
                categorias = JSON.parse(JSON.stringify(data));

                $(".categorias").html('<option>Selecione</option>');
                $('select[name="sel_carteira"]').empty();
                $.each(categorias, function (i, categoria) {
                    $(".categorias").append($('<option>', {
                        value: categoria.id, //Id do objeto ategoria
                        text: categoria.name //Nome da categoria
                    }));
                });
            }
        });
    }

    function selectSubCategory(id)
    {
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
        var api = '<?php echo API; ?>';

        $.ajax({
            type: 'POST',
            url: api + "categories/" + id + "/subcategories",
            headers: {'X-Authorization': `Bearer ${token}`},
            success: function (data) {
                subcategorias = JSON.parse(JSON.stringify(data));

                $(".subcategorias").html('<option>Selecione</option>');
                $('select[name="sel_carteira"]').empty();
                $.each(subcategorias, function (i, subcategoria) {
                    $(".subcategorias").append($('<option>', {
                        value: subcategoria.id, //Id do objeto subcategoria
                        text: subcategoria.name //Nome da Subcategoria
                    }));
                });
            }
        });
    }





    $(function () {
        $(document).on("change", ".uploadFile", function ()
        {
            var uploadFile = $(this);
            var files = !!this.files ? this.files : [];
            if (!files.length || !window.FileReader)
                return; // no file selected, or no FileReader support

            if (/^image/.test(files[0].type)) { // only image file
                var reader = new FileReader(); // instance of the FileReader
                reader.readAsDataURL(files[0]); // read the local file

                reader.onloadend = function () { // set image data as background of div
                    //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                    uploadFile.closest(".imgUp").find('.imagePreview').css("background-image", "url(" + this.result + ")");
                }
            }

        });
    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>