#!/bin/bash
# Script para upload das correções no servidor via cPanel terminal
# Copie e cole este script no terminal do cPanel

echo "=== ATUALIZANDO ARQUIVOS CORRIGIDOS ==="

# Diretório base do painel (ajuste se necessário)
PAINEL_DIR="/home/eulevoai/public_html/painel"

# Backup dos arquivos originais
echo "1. Fazendo backup dos arquivos originais..."
BACKUP_DIR="/home/eulevoai/backup_$(date +%Y%m%d_%H%M%S)"
mkdir -p "$BACKUP_DIR"

# Lista de arquivos para atualizar
declare -A files
files["app/Config.php"]="painel_app_analysis/app/Config.php"
files["resource/layouts/main.php"]="painel_app_analysis/resource/layouts/main.php"
files["public/config.php"]="painel_app_analysis/public/config.php"

# Copiar arquivos para o servidor (simulação - na prática, você fará upload via FTP/File Manager)
echo "2. Preparando arquivos para upload..."
echo ""
echo "=== ARQUIVOS PARA UPLOAD MANUAL ==="
echo ""
echo "Faça upload manual dos seguintes arquivos via File Manager do cPanel:"
echo ""

for dest in "${!files[@]}"; do
    src="${files[$dest]}"
    echo "Origem local: $src"
    echo "Destino no servidor: $PAINEL_DIR/$dest"
    echo "---"
done

echo ""
echo "=== INSTRUÇÕES PARA UPLOAD ==="
echo "1. Acesse o File Manager do cPanel"
echo "2. Navegue até: /home/eulevoai/public_html/painel"
echo "3. Faça backup dos arquivos originais"
echo "4. Substitua pelos arquivos listados acima"
echo "5. Após upload, teste a dashboard"
echo ""
echo "=== CONTEÚDO DAS ALTERAÇÕES ==="
echo ""
echo "1. app/Config.php: ROOT alterado para HTTPS"
echo "2. resource/layouts/main.php: Removidos resumos fake"
echo "3. public/config.php: Título dinâmico robusto"
echo ""
echo "=== TESTE APÓS UPLOAD ==="
echo "1. Recarregue a dashboard (Ctrl+F5)"
echo "2. Verifique se o título muda conforme tipo de usuário"
echo "3. Confirme que dados fake do menu lateral sumiram"
echo "4. Verifique se contadores carregam dados reais"

# Script alternativo usando curl para upload direto (se houver acesso)
echo ""
echo "=== ALTERNATIVA: UPLOAD VIA CURL (se configurado) ==="
echo "# Para cada arquivo, execute:"
echo "curl -F 'file=@arquivo_local' https://painel.eulevoai.com.br/upload-endpoint"
echo ""
echo "=== FIM DO SCRIPT ==="
