<?php $v->layout('layouts/main', ['title' => 'Slider/Banners']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }

    .imagePreview {
        width: 100%;
        height: 180px;
        background-position: center center;
        background-image: url('assets/media/image/not.png');
        background-color:#fff;
        background-size: cover;
        background-repeat:no-repeat;
        display: inline-block;
        box-shadow:0px -3px 6px 2px rgba(0,0,0,0.2);
    }
    .imgUp
    {
        margin-bottom:15px;
    }
    .imgAdd
    {
        width:30px;
        height:30px;
        border-radius:50%;
        background-color:#4bd7ef;
        color:#fff;
        box-shadow:0px 0px 2px 1px rgba(0,0,0,0.2);
        text-align:center;
        line-height:30px;
        margin-top:0px;
        cursor:pointer;
        font-size:15px;
    }
    .btn{
        width: 100%;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Slider/Banners</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Slider/Banners</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadSliderBanner">
                    <i class="fa fa-plus"></i> &nbsp; Novo Slider/Banner
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="banners" class="table table-lg">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Slider/Banner</th>
                                <th>Local</th>
                                <th>Ordenação</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR BANNER -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadSliderBanner">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Slider/Banner</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarSliderBanner" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-sm-6 offset-md-3 imgUp">
                                    <div class="imagePreview"></div>
                                    <label class="btn btn-primary">
                                        Foto<input type="file" class="uploadFile img" value="Foto" style="width: 0px;height: 0px;overflow: hidden;" name="image" accept="image/*">
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="name">Slider/Banner</label>
                                <input type="text" class="form-control" name="name" maxlength="50">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="local">Local</label>
                                <input type="text" class="form-control" name="local" maxlength="50">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="ranking">Ordenação</label>
                                <input type="number" class="form-control" name="ranking" min="1">
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadSliderBanner">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR BANNER -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditSliderBanner">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Slider/Banner</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarSliderBanner" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-sm-6 offset-md-3 imgUp">
                                    <div class="imagePreview"></div>
                                    <label class="btn btn-primary">
                                        Foto<input type="file" class="uploadFile img" value="Foto" style="width: 0px;height: 0px;overflow: hidden;" name="image" accept="image/*">
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <input type="hidden" id="id_banner">
                                <label for="name">Slider/Banner</label>
                                <input type="text" class="form-control" name="name" maxlength="50" id="name_banner">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="local">Local</label>
                                <input type="text" class="form-control" name="local" maxlength="50" id="local_banner">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="ranking">Ordenação</label>
                                <input type="number" class="form-control" name="ranking" min="1" id="ranking_banner">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditSliderBanner">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };

    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#apps_e > a').addClass("active");
        $('div#apps').addClass("open");
        $('a#banners').addClass("active");
        

        var api = '<?php echo API; ?>';
        var img = '<?php echo IMG; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        // carregar a tabela de banner
        $('#banners').DataTable({
            "ajax": {
                "url": api + "banners",
                "type": 'GET',
                "headers": {'X-Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": null,
                    "render": function (data, type, row, meta) {
                        return '<img src="' + img + row["tenant_id"] + '/banners/' + data["link"] + '.jpg" width="80">';
                    }
                },
                {"data": "name"},
                {"data": "local"},
                {"data": "ranking"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>';
                    }
                },
            ]
        });
    });


    $(document).ready(function () {

        // cadastrar o banner
        $(document).on('click', '#btnCadSliderBanner', function () {

            var form = new FormData($('#frmCadastrarSliderBanner')[0]);
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "banners",
                type: 'POST',
                enctype: 'multipart/form-data',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Slider/Banner cadastrado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarSliderBanner').trigger("reset");
                    $('#modalCadSliderBanner').modal('hide');
                    $('#banners').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditSliderBanner, #modalCadSliderBanner').on('hidden.bs.modal', function () {
            $('#frmEditarSliderBanner input').each(function () {
                $(this).val('');
                $('.imagePreview').css("background-image", "url(/assets/media/image/not.png)");
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';
            var img = '<?php echo IMG; ?>';

            // submit form data to api
            $.ajax({
                url: api + "banners/" + item_id,
                type: 'GET',
                headers: {"X-Authorization": `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_banner').val(data.id);
                    $('#name_banner').val(data.name);
                    $('#local_banner').val(data.local);
                    $('#ranking_banner').val(data.ranking);
                    $('.imagePreview').css("background-image", "url(" + img + data.tenant_id + '/banners/' + data.link + '.jpg' + "),url(assets/media/image/not.png)");
                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditSliderBanner').modal('show');
        });


        // editar o banner
        $(document).on('click', '#btnEditSliderBanner', function () {

            var id = $('#id_banner').val();
            var form = new FormData($('#frmEditarSliderBanner')[0]);
//            var form = $('#frmEditarSliderBanner').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "banners/" + id + '/editar',
                type: 'POST',
                enctype: 'multipart/form-data',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form,
                cache: false,
                contentType: false,
                processData: false,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Slider/Banner alterado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarSliderBanner').trigger("reset");
                    $('#modalEditSliderBanner').modal('hide');

                    $('#banners').DataTable().clear().draw();
                    $('#banners').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar este banner?');
            if (confirmado) {

                $.ajax({
                    url: api + "banners/" + item_id,
                    type: 'DELETE',
                    headers: {"X-Authorization": `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Slider/Banner excluído com sucesso!',
                            timeout: 6000,
                        });

                        $('#banners').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });

    });





    $(function () {
        $(document).on("change", ".uploadFile", function ()
        {
            var uploadFile = $(this);
            var files = !!this.files ? this.files : [];
            if (!files.length || !window.FileReader)
                return; // no file selected, or no FileReader support

            if (/^image/.test(files[0].type)) { // only image file
                var reader = new FileReader(); // instance of the FileReader
                reader.readAsDataURL(files[0]); // read the local file

                reader.onloadend = function () { // set image data as background of div
                    //alert(uploadFile.closest(".upimage").find('.imagePreview').length);
                    uploadFile.closest(".imgUp").find('.imagePreview').css("background-image", "url(" + this.result + ")");
                }
            }

        });
    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>