<?php $v->layout('layouts/main', ['title' => 'Entregadores']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Entregadores</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Entregadores</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadEntregador">
                    <i class="fa fa-plus"></i> &nbsp; Novo Entregador
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="couriers" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Entregador</th>
                                <th>Telefone</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR ENTREGADOR -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadEntregador">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Entregador</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarEntregador">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Entregador</label>
                                <input type="text" class="form-control" name="name" placeholder="Entregador" maxlength="50">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="phone">Telefone</label>
                                <input type="text" class="form-control" name="phone" placeholder="Telefone" maxlength="15">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="cnh">CNH</label>
                                <input type="text" class="form-control" name="cnh" placeholder="CNH" maxlength="15">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="rg">RG</label>
                                <input type="text" class="form-control" name="rg" placeholder="RG" maxlength="15">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="cpf">CPF</label>
                                <input type="text" class="form-control value" name="cpf" placeholder="CPF" maxlength="14">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadEntregador">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR ENTREGADOR -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditEntregador">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Entregador</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarEntregador">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" id="id_courier">
                                <label for="name">Nome</label>
                                <input type="text" class="form-control" name="name" placeholder="Nome do Entregador" maxlength="50" id="name_courier">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="phone">Telefone</label>
                                <input type="text" class="form-control" name="phone" placeholder="Telefone" maxlength="15" id="phone_courier">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="cnh">CNH</label>
                                <input type="text" class="form-control" name="cnh" placeholder="CNH" maxlength="15" id="cnh_courier">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="rg">RG</label>
                                <input type="text" class="form-control" name="rg" placeholder="RG" maxlength="15" id="rg_courier">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="cpf">CPF</label>
                                <input type="text" class="form-control" name="cpf" placeholder="CPF" maxlength="14" id="cpf_courier">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditEntregador">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };

    // carregar a tabela de entregadores
    $(window).on('load', function () {        
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#projects_e > a').addClass("active");
        $('div#projects').addClass("open");
        $('a#entregadores').addClass("active");
        

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#couriers').DataTable({
            "ajax": {
                "url": api + "couriers",
                "type": 'GET',
                "headers": {'X-Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": "name"},
                {"data": "phone"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                },
            ]
        });
    });


    $(document).ready(function () {

        // cadastrar o entregador
        $(document).on('click', '#btnCadEntregador', function () {

            // get form data
            var form_data = $('#frmCadastrarEntregador').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "couriers",
                type: 'POST',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Entregador cadastrado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarEntregador').trigger("reset");
                    $('#modalCadEntregador').modal('hide');
                    $('#couriers').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditEntregador').on('hidden.bs.modal', function () {
            $('#frmEditarEntregador input').each(function () {
                $(this).val('');
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "couriers/" + item_id,
                type: 'GET',
                headers: {"X-Authorization": `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_courier').val(data.id);
                    $('#name_courier').val(data.name);
                    $('#phone_courier').val(data.phone);
                    $('#cnh_courier').val(data.cnh);
                    $('#rg_courier').val(data.rg);
                    $('#cpf_courier').val(data.cpf);

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditEntregador').modal('show');
        });


        // editar o entregador
        $(document).on('click', '#btnEditEntregador', function () {

            var id = $('#id_courier').val();
            var form_data = $('#frmEditarEntregador').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "couriers/" + id,
                type: 'PUT',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Entregador alterado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarEntregador').trigger("reset");
                    $('#modalEditEntregador').modal('hide');
                    $('#couriers').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });



        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar este entregador?');
            if (confirmado) {

                $.ajax({
                    url: api + "couriers/" + item_id,
                    type: 'DELETE',
                    headers: {"X-Authorization": `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Entregador excluído com sucesso!',
                            timeout: 6000,
                        });

                        $('#couriers').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });
    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>