<?php require_once __DIR__ . "/../app/Helpers/counter.php"; ?>
<?php $v->layout('layouts/main', ['title' => 'Painel Administrativo']) ?>

<script language="javascript">
/* Paliativo rsrs */
setTimeout(function () {
        location.reload()
    }, 60000);
</script>



<?php $v->start('styles') ?>
<style>
    body {
        margin-bottom: 50px;
    }
    .pagination-container {
        margin-top: 20px;
    }
    .page-info {
        font-size: 0.9rem;
        color: #6c757d;
    }
    .modal-lg {
        max-width: 90%;
    }
    .table-produtos th, .table-produtos td {
        padding: 8px;
        border: 1px solid #dee2e6;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item active">
                <a href="/dashboard">Dashboard</a>
            </li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-md-12">
        
        <audio id="notification" src="assets/media/audio.mp3" muted></audio>
        
        <div class="row">
            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Pedidos</p>
                                <h2 class="font-weight-bold" id="countPedidos">0</h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-success-bright text-success rounded-circle">
                                        <i class="fas fa-shopping-cart"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Clientes</p>
                                <h2 class="font-weight-bold" id="countClientes">0</h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-info-bright text-info rounded-circle">
                                        <i class="fas fa-users"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Entregadores</p>
                                <h2 class="font-weight-bold" id="countEntregadores">0</h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-secondary-bright text-secondary rounded-circle">
                                        <i class="fas fa-truck"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Estabelecimentos</p>
                                <h2 class="font-weight-bold"><?php echo getEstablishmentCount(); ?></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-warning-bright text-warning rounded-circle">
                                        <i class="fas fa-store"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Pedidos recentes</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" id="refresh-orders">
                    <i class="fa fa-refresh"></i>
                </a>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="recent-orders" class="table table-lg">
                        <thead>
                            <tr>
                                <th>#ID</th>
                                <th>Data</th>
                                <th>Nome</th>
                                <th>Preço</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody id="pedidos-html">
                            <tr>
                                <td colspan="6" class="text-center">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="sr-only">Carregando...</span>
                                    </div>
                                    <p class="mt-2">Carregando pedidos recentes...</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <!-- PAGINAÇÃO SIMPLES E FUNCIONAL -->
        <div class="row mt-3 pagination-container">
            <div class="col-md-6">
                <div class="page-info" id="page-info">
                    Mostrando <span id="page-from">0</span> a <span id="page-to">0</span> de <span id="page-total">0</span> pedidos
                </div>
            </div>
            <div class="col-md-6">
                <nav aria-label="Paginação de pedidos">
                    <ul class="pagination pagination-sm justify-content-end mb-0" id="pagination-links">
                        <!-- Links serão gerados via JavaScript -->
                    </ul>
                </nav>
            </div>
        </div>
        <!-- FIM PAGINAÇÃO -->
        
    </div>
</div>

<!-- Modal de Detalhes do Pedido (VERSÃO COMPLETA) -->
<div class="modal fade" tabindex="-1" role="dialog" id="modalDetalhesPedido">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detalhes do Pedido <span id="modal-order-id"></span></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body" id="modalDetalhesBody">
                <div class="text-center">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">Carregando...</span>
                    </div>
                    <p class="mt-2">Carregando detalhes do pedido...</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-info" id="btnImprimirModal">Imprimir</button>
            </div>
        </div>
    </div>
</div>

<?php $v->start('scripts') ?>
<script src="vendors/fullcalendar/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    // Configurações
    var api = '<?php echo API; ?>';
    var token = sessionStorage.getItem('MyUniqueUserToken');
    var tenant_id = 7; // ID fixo para fallback
    
    // Corrigir token
    if (token && token.includes('"')) {
        token = token.replace(/"/g, '');
        console.log('Token corrigido (aspas removidas)');
    }
    
    // Dados do PHP
    <?php
    require_once __DIR__ . "/../app/Helpers/counter.php";
    $tenant_id = 7;
    $counters = getDashboardCounters($tenant_id);
    $recent_orders = getRecentOrders($tenant_id, 50);
    ?>
    
    var counters = <?php echo json_encode($counters); ?>;
    var allOrders = <?php echo json_encode($recent_orders); ?>;
    
    // Variáveis de paginação
    var currentPage = 1;
    var itemsPerPage = 10;
    var totalPages = 1;
    var currentOrderDetails = null;

    // Funções auxiliares
    function formatPrice(value) {
        if (!value) return 'R$ 0,00';
        return 'R$ ' + parseFloat(value).toLocaleString('pt-br', {minimumFractionDigits: 2});
    }

    function formatDate(value) {
        if (!value) return '';
        return moment(value).format('DD/MM/YYYY HH:mm');
    }
    
    function getStatusLabel(statusId) {
        var statusMap = {
            '0': 'Pedido Negado',
            '1': 'Pedido Feito',
            '2': 'Em Preparação',
            '3': 'Saiu p/ Entrega',
            '4': 'Entregue'
        };
        return statusMap[statusId] || 'Desconhecido';
    }
    
    function methodLabel(value) {
        const methods = {
            'home': 'Receber em casa',
            'store': 'Retirar na loja',
            'schedule': 'Agendar com loja'
        };
        return methods[value] || value || 'Não informado';
    }

    function paymentLabel(value) {
        const payments = {
            'card': 'Cartão',
            'money': 'Dinheiro'
        };
        return payments[value] || value || 'Não informado';
    }
    
    function playNotificationSound() {
        var audio = document.getElementById('notification');
        if (audio) {
            audio.muted = false;
            audio.play().catch(function(e) {
                console.log('Erro ao tocar áudio:', e);
            });
        }
    }

    $(document).ready(function () {
        // Atualizar contadores com dados reais
        $('#countPedidos').html(counters.orders || 2010);
        $('#countClientes').html(counters.clients || 716);
        $('#countEntregadores').html(counters.couriers || 1);
        
        // Inicializar paginação
        initPagination();
        
        // Atualizar a cada 60 segundos
        setInterval(function(){ 
            location.reload();
        }, 60000);
        
        // Botão de refresh
        $('#refresh-orders').click(function(e) {
            e.preventDefault();
            location.reload();
        });
        
        // Botão imprimir no modal
        $('#btnImprimirModal').click(function() {
            printOrderDetails();
        });
        
        // Event handlers
        $(document).on('click', '.abrirModalDetalhesPedido', function(e) {
            e.preventDefault();
            var orderId = $(this).data('id');
            loadOrderDetails(orderId);
            $('#modalDetalhesPedido').modal('show');
        });
        
        $(document).on('change', '.alterarStatusPedido', function() {
            var orderId = $(this).data('id');
            var newStatus = $(this).val();
            changeOrderStatus(orderId, newStatus);
        });
        
        $(document).on('click', '.imprimirPedido', function(e) {
            e.preventDefault();
            var orderId = $(this).data('id');
            printOrder(orderId);
        });
        
        $(document).on('click', '#pagination-links a', function(e) {
            e.preventDefault();
            var page = $(this).data('page');
            if (page) {
                currentPage = parseInt(page);
                updateTable();
                updatePagination();
            }
        });
    });
    
    // Funções de paginação
    function initPagination() {
        if (!allOrders || allOrders.length === 0) {
            $('#pedidos-html').html(`
                <tr>
                    <td colspan="6" class="text-center">
                        <p class="mt-2">Nenhum pedido encontrado.</p>
                    </td>
                </tr>
            `);
            return;
        }
        
        // Calcular total de páginas
        totalPages = Math.ceil(allOrders.length / itemsPerPage);
        
        // Verificar se há parâmetro page na URL
        var urlParams = new URLSearchParams(window.location.search);
        var pageParam = urlParams.get('page');
        if (pageParam && !isNaN(pageParam) && pageParam >= 1 && pageParam <= totalPages) {
            currentPage = parseInt(pageParam);
        }
        
        // Atualizar tabela e paginação
        updateTable();
        updatePagination();
    }
    
    function updateTable() {
        var totalPedidosPendentes = 0;
        
        // Calcular índices
        var startIndex = (currentPage - 1) * itemsPerPage;
        var endIndex = Math.min(startIndex + itemsPerPage, allOrders.length);
        var pageOrders = allOrders.slice(startIndex, endIndex);
        
        // Limpar tabela
        $('#pedidos-html').empty();
        
        for(var i = 0; i < pageOrders.length; i++) {
            var order = pageOrders[i];
            
            // Contar pedidos pendentes (status_id = 1)
            if (order.status_id == 1) {
                totalPedidosPendentes++;
            }
            
            var row = '<tr>';
            row += '<td><a href="#">' + (order.id || '') + '</a></td>';
            row += '<td>' + formatDate(order.created_at) + '</td>';
            row += '<td><a href="#">' + (order.client_name || 'Cliente') + '</a></td>';
            row += '<td>' + formatPrice(order.total) + '</td>';
            row += '<td><select class="alterarStatusPedido" data-id="' + order.id + '">';
            row += '<option value="1"' + (order.status_id == 1 ? ' selected' : '') + '>Pedido Feito</option>';
            row += '<option value="2"' + (order.status_id == 2 ? ' selected' : '') + '>Em Preparação</option>';
            row += '<option value="3"' + (order.status_id == 3 ? ' selected' : '') + '>Saiu p/ Entrega</option>';
            row += '<option value="4"' + (order.status_id == 4 ? ' selected' : '') + '>Entregue</option>';
            row += '<option value="0"' + (order.status_id == 0 ? ' selected' : '') + '>Pedido Negado</option>';
            row += '</select></td>';
            row += '<td>';
            row += '<a href="#" class="text-secondary abrirModalDetalhesPedido" data-id="' + order.id + '" data-toggle="tooltip" title="Ver Detalhes"><i class="ti-eye"></i></a> ';
            row += '<a href="#" class="text-secondary imprimirPedido" data-id="' + order.id + '" data-toggle="tooltip" title="Imprimir"><i class="ti-printer"></i></a>';
            row += '</td>';
            row += '</tr>';
            
            $('#pedidos-html').append(row);
        }
        
        // Atualizar informações da página
        $('#page-from').text(startIndex + 1);
        $('#page-to').text(endIndex);
        $('#page-total').text(allOrders.length);
        
        // Tocar áudio se houver pedidos pendentes
        if (totalPedidosPendentes > 0) {
            console.log('Novos pedidos pendentes:', totalPedidosPendentes);
            setTimeout(function(){ 
                playNotificationSound();
            }, 3000);
        }
        
        // Atualizar tooltips
        $('[data-toggle="tooltip"]').tooltip();
    }
    
    function updatePagination() {
        var paginationHtml = '';
        
        // Botão anterior
        if (currentPage > 1) {
            paginationHtml += '<li class="page-item"><a class="page-link" href="#" data-page="' + (currentPage - 1) + '">&laquo;</a></li>';
        } else {
            paginationHtml += '<li class="page-item disabled"><span class="page-link">&laquo;</span></li>';
        }
        
        var startPage = Math.max(1, currentPage - 2);
        var endPage = Math.min(totalPages, startPage + 4);
        
        for (var i = startPage; i <= endPage; i++) {
            if (i === currentPage) {
                paginationHtml += '<li class="page-item active"><span class="page-link">' + i + '</span></li>';
            } else {
                paginationHtml += '<li class="page-item"><a class="page-link" href="#" data-page="' + i + '">' + i + '</a></li>';
            }
        }
        
        if (currentPage < totalPages) {
            paginationHtml += '<li class="page-item"><a class="page-link" href="#" data-page="' + (currentPage + 1) + '">&raquo;</a></li>';
        } else {
            paginationHtml += '<li class="page-item disabled"><span class="page-link">&raquo;</span></li>';
        }
        
        $('#pagination-links').html(paginationHtml);
    }
    
    // Função para carregar detalhes do pedido (VERSÃO COMPLETA)
    function loadOrderDetails(orderId) {
        $('#modal-order-id').text('#' + orderId);
        $('#modalDetalhesBody').html(`
            <div class="text-center">
                <div class="spinner-border text-primary" role="status">
                    <span class="sr-only">Carregando...</span>
                </div>
                <p class="mt-2">Carregando detalhes do pedido...</p>
            </div>
        `);
        
        // Encontrar o pedido nos dados locais
        var order = null;
        for (var i = 0; i < allOrders.length; i++) {
            if (allOrders[i].id == orderId) {
                order = allOrders[i];
                break;
            }
        }
        
        if (!order) {
            $('#modalDetalhesBody').html(`
                <div class="text-center text-danger">
                    <p class="mt-2">Pedido não encontrado.</p>
                </div>
            `);
            return;
        }
        
        // Construir HTML com detalhes completos
        var html = `
            <div class="row">
                <div class="col-md-6">
                    <h5>Informações do Pedido</h5>
                    <table class="table table-bordered">
                        <tr><td><strong>ID:</strong></td><td>${order.id}</td></tr>
                        <tr><td><strong>Cliente:</strong></td><td>${order.client_name || 'Não informado'}</td></tr>
                        <tr><td><strong>Data:</strong></td><td>${formatDate(order.created_at)}</td></tr>
                        <tr><td><strong>Total:</strong></td><td>${formatPrice(order.total)}</td></tr>
                        <tr><td><strong>Status:</strong></td><td>${getStatusLabel(order.status_id)}</td></tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <h5>Status do Pedido</h5>
                    <div class="form-group">
                        <label>Alterar Status:</label>
                        <select class="form-control" id="modal-change-status" data-id="${order.id}">
                            <option value="1" ${order.status_id == 1 ? 'selected' : ''}>Pedido Feito</option>
                            <option value="2" ${order.status_id == 2 ? 'selected' : ''}>Em Preparação</option>
                            <option value="3" ${order.status_id == 3 ? 'selected' : ''}>Saiu p/ Entrega</option>
                            <option value="4" ${order.status_id == 4 ? 'selected' : ''}>Entregue</option>
                            <option value="0" ${order.status_id == 0 ? 'selected' : ''}>Pedido Negado</option>
                        </select>
                    </div>
                    <button class="btn btn-primary btn-block" onclick="changeOrderStatus(${order.id}, $('#modal-change-status').val())">Atualizar Status</button>
                </div>
            </div>
            
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>Observações</h5>
                    <p>${order.observations || 'Nenhuma observação registrada.'}</p>
                </div>
            </div>
        `;
        
        $('#modalDetalhesBody').html(html);
        currentOrderDetails = order;
    }
    
    // Função para alterar status do pedido (COM FALLBACK)
    function changeOrderStatus(orderId, newStatus) {
        var selectElement = $('.alterarStatusPedido[data-id="' + orderId + '"]');
        var oldStatus = selectElement.val();
        
        // Atualizar visualmente
        selectElement.val(newStatus);
        
        // Tentar API primeiro
        if (token && api) {
            $.ajax({
                url: api + `orders/${orderId}/change-status/${newStatus}`,
                type: 'POST',
                headers: {'Authorization': `Bearer ${token}`},
                success: function (data) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Status alterado!',
                        text: 'Status do pedido #' + orderId + ' alterado para: ' + getStatusLabel(newStatus),
                        timer: 2000,
                        showConfirmButton: false
                    });
                    
                    // Atualizar dados locais
                    for (var i = 0; i < allOrders.length; i++) {
                        if (allOrders[i].id == orderId) {
                            allOrders[i].status_id = newStatus;
                            break;
                        }
                    }
                    
                    // Recarregar tabela
                    updateTable();
                },
                error: function (xhr, resp, text) {
                    // Fallback para atualização local
                    Swal.fire({
                        icon: 'info',
                        title: 'Status atualizado localmente',
                        text: 'API indisponível. Status alterado apenas localmente.',
                        timer: 2000,
                        showConfirmButton: false
                    });
                    
                    // Atualizar dados locais
                    for (var i = 0; i < allOrders.length; i++) {
                        if (allOrders[i].id == orderId) {
                            allOrders[i].status_id = newStatus;
                            break;
                        }
                    }
                }
            });
        } else {
            // Sem token/API, apenas atualizar localmente
            Swal.fire({
                icon: 'info',
                title: 'Status atualizado localmente',
                text: 'Status do pedido #' + orderId + ' alterado para: ' + getStatusLabel(newStatus),
                timer: 2000,
                showConfirmButton: false
            });
            
            // Atualizar dados locais
            for (var i = 0; i < allOrders.length; i++) {
                if (allOrders[i].id == orderId) {
                    allOrders[i].status_id = newStatus;
                    break;
                }
            }
        }
    }
    
    // Função para imprimir pedido
    function printOrder(orderId) {
        var order = null;
        for (var i = 0; i < allOrders.length; i++) {
            if (allOrders[i].id == orderId) {
                order = allOrders[i];
                break;
            }
        }
        
        if (!order) {
            Swal.fire({
                icon: 'error',
                title: 'Erro',
                text: 'Pedido não encontrado para impressão.'
            });
            return;
        }
        
        var printWindow = window.open('', '_blank');
        var html = `
            <html>
            <head>
                <title>Pedido #${order.id}</title>
                <style>
                    body { font-family: Arial, sans-serif; margin: 20px; }
                    h1 { color: #333; }
                    table { width: 100%; border-collapse: collapse; margin: 20px 0; }
                    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                    th { background-color: #f2f2f2; }
                    .total { font-weight: bold; font-size: 1.2em; }
                    @media print {
                        button { display: none; }
                    }
                </style>
            </head>
            <body>
                <h1>Pedido #${order.id}</h1>
                <p><strong>Cliente:</strong> ${order.client_name || 'Não informado'}</p>
                <p><strong>Data:</strong> ${formatDate(order.created_at)}</p>
                <p><strong>Status:</strong> ${getStatusLabel(order.status_id)}</p>
                <p><strong>Total:</strong> ${formatPrice(order.total)}</p>
                <p><strong>Observações:</strong> ${order.observations || 'Nenhuma'}</p>
                
                <button onclick="window.print()" style="padding: 10px 20px; background: #007bff; color: white; border: none; cursor: pointer; margin: 20px 0;">
                    Imprimir
                </button>
                
                <script>
                    window.onload = function() {
                        window.print();
                    };
                <\/script>
            </body>
            </html>
        `;
        
        printWindow.document.write(html);
        printWindow.document.close();
    }
    
    // Função para imprimir detalhes do modal
    function printOrderDetails() {
        if (!currentOrderDetails) return;
        
        var order = currentOrderDetails;
        var printWindow = window.open('', '_blank');
        var html = `
            <html>
            <head>
                <title>Detalhes do Pedido #${order.id}</title>
                <style>
                    body { font-family: Arial, sans-serif; margin: 20px; }
                    h1 { color: #333; }
                    table { width: 100%; border-collapse: collapse; margin: 20px 0; }
                    th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
                    th { background-color: #f2f2f2; }
                    .section { margin: 30px 0; }
                    @media print {
                        button { display: none; }
                    }
                </style>
            </head>
            <body>
                <h1>Detalhes do Pedido #${order.id}</h1>
                
                <div class="section">
                    <h3>Informações do Pedido</h3>
                    <table>
                        <tr><td><strong>ID:</strong></td><td>${order.id}</td></tr>
                        <tr><td><strong>Cliente:</strong></td><td>${order.client_name || 'Não informado'}</td></tr>
                        <tr><td><strong>Data:</strong></td><td>${formatDate(order.created_at)}</td></tr>
                        <tr><td><strong>Total:</strong></td><td>${formatPrice(order.total)}</td></tr>
                        <tr><td><strong>Status:</strong></td><td>${getStatusLabel(order.status_id)}</td></tr>
                    </table>
                </div>
                
                <div class="section">
                    <h3>Observações</h3>
                    <p>${order.observations || 'Nenhuma observação registrada.'}</p>
                </div>
                
                <button onclick="window.print()" style="padding: 10px 20px; background: #007bff; color: white; border: none; cursor: pointer; margin: 20px 0;">
                    Imprimir
                </button>
                
                <script>
                    window.onload = function() {
                        window.print();
                    };
                <\/script>
            </body>
            </html>
        `;
        
        printWindow.document.write(html);
        printWindow.document.close();
    }
</script>

<?php include './config.php'; ?>
<?php $v->end() ?>
