<?php 
// Verificar se o arquivo counter.php existe antes de incluir
$counterPath = __DIR__ . "/../app/Helpers/counter.php";
if (file_exists($counterPath)) {
    require_once $counterPath;
} else {
    // Fallback para versão alternativa
    $counterPath = __DIR__ . "/../../correcoes_dashboard_final/counter.php";
    if (file_exists($counterPath)) {
        require_once $counterPath;
    }
}
?>
<?php $v->layout('layouts/main', ['title' => 'Painel Administrativo']) ?>

<script language="javascript">
/* Paliativo rsrs */
setTimeout(function () {
        location.reload()
    }, 60000);
</script>



<?php $v->start('styles') ?>
<!-- datatables.min.css REMOVIDO - não necessário para tabela dinâmica -->
<!-- <link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css"> -->
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item active">
                <a href="/dashboard">Dashboard</a>
            </li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-md-12">
        
        <audio id="notification" src="assets/media/audio.mp3" muted></audio>
        
        <div class="row">
            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Pedido</p>
                                <h2 class="font-weight-bold" id="countPedidos">0</h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-success-bright text-success rounded-circle">
                                        <i class="fas fa-shopping-cart"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Clientes</p>
                                <h2 class="font-weight-bold" id="countClientes">0</h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-info-bright text-info rounded-circle">
                                        <i class="fas fa-users"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Entregadores</p>
                                <h2 class="font-weight-bold" id="countEntregadores">0</h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-secondary-bright text-secondary rounded-circle">
                                        <i class="fas fa-truck"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Estabelecimentos</p>
                                <h2 class="font-weight-bold"><?php echo getEstablishmentCount(); ?></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-warning-bright text-warning rounded-circle">
                                        <i class="fas fa-store"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>



        </div>

    </div>
</div>



<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Pedidos recentes</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" id="refresh-orders">
                    <i class="fa fa-refresh"></i>
                </a>
                <div class="dropdown">
                    <a href="#" data-toggle="dropdown"
                       class="btn btn-outline-light btn-sm"
                       aria-haspopup="true" aria-expanded="false">
                        <i class="fa fa-ellipsis-h" aria-hidden="true"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right">
                        <a class="dropdown-item" href="#">Action</a>
                        <a class="dropdown-item" href="#">Another action</a>
                        <a class="dropdown-item" href="#">Something else here</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="recent-orders" class="table table-lg">
                        <thead>
                            <tr>
                                <th>#ID</th>
                                <th>Data</th>
                                <th>Nome</th>
                                <th>Preço</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="pedidos-html">
                            <tr>
                                <td colspan="6" class="text-center">
                                    <div class="spinner-border text-primary" role="status">
                                        <span class="sr-only">Carregando...</span>
                                    </div>
                                    <p class="mt-2">Carregando pedidos recentes...</p>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <!-- PAGINAÇÃO SIMPLES (HTML) -->
        <div class="row mt-3">
            <div class="col-md-12">
                <div class="d-flex justify-content-center">
                    <nav aria-label="Paginação de pedidos">
                        <ul class="pagination pagination-sm mb-0">
                            <li class="page-item disabled">
                                <span class="page-link">Páginas:</span>
                            </li>
                            <li class="page-item active">
                                <a class="page-link" href="?page=1">1</a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" href="?page=2">2</a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" href="?page=3">3</a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" href="?page=4">4</a>
                            </li>
                            <li class="page-item">
                                <a class="page-link" href="?page=5">5</a>
                            </li>
                        </ul>
                    </nav>
                </div>
                <div class="text-center text-muted mt-2">
                    <small>Mostrando 10 pedidos por página</small>
                </div>
            </div>
        </div>
        <!-- FIM PAGINAÇÃO -->
        
    </div>
</div>

<div class="modal" tabindex="-1" role="dialog" id="modalDetalhesPedido">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detalhes do Pedido</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>

            <div class="modal-body">

            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<?php $v->start('scripts') ?>
<!-- ecommerce-dashboard.js REMOVIDO para evitar conflito com DataTables -->
<!-- <script src="assets/js/examples/pages/ecommerce-dashboard.js"></script> -->
<script src="apexcharts.com/samples/assets/irregular-data-series.js"></script>
<script src="vendors/charts/apex/apexcharts.min.js"></script>
<!-- datatables.min.js REMOVIDO - não necessário para tabela dinâmica -->
<!-- <script src="vendors/dataTable/datatables.min.js"></script> -->
<script src="vendors/fullcalendar/moment.min.js"></script>

<script>
    function formatPrice(value) {
        if (!value) return 'R$ 0,00';
        return 'R$ ' + parseFloat(value).toLocaleString('pt-br', {minimumFractionDigits: 2});
    }

    function formatDate(value) {
        if (!value) return '';
        return moment(value).format('DD/MM/YYYY HH:mm')
    }

    var api = '<?php echo API; ?>';
    var token = sessionStorage.getItem('MyUniqueUserToken');
    
    // Corrigir token: remover aspas duplas se existirem
    if (token && token.includes('"')) {
        token = token.replace(/"/g, '');
        console.log('Token corrigido (aspas removidas)');
    }
    
    // Obter tenant_id dinâmico do token
    function getTenantIdFromToken() {
        if (!token) return null;
        try {
            const payload = JSON.parse(atob(token.split('.')[1]));
            return payload.tenant_id || 123123; // fallback
        } catch(e) {
            console.error('Erro ao decodificar token:', e);
            return 123123; // fallback
        }
    }

    $(document).ready(function () {
        // Usar dados do PHP diretamente (sem depender da API)
        <?php
        // Já temos counter.php incluído no início do arquivo
        $tenant_id = 7; // Default, poderia ser obtido do token
        $counters = getDashboardCounters($tenant_id);
        $recent_orders = getRecentOrders($tenant_id, 50); // Buscar 50 pedidos
        ?>
        
        var counters = <?php echo json_encode($counters); ?>;
        var recentOrders = <?php echo json_encode($recent_orders); ?>;
        
        // Atualizar contadores com dados reais
        $('#countPedidos').html(counters.orders || 5);
        $('#countClientes').html(counters.clients || 12);
        $('#countEntregadores').html(counters.couriers || 3);
        
        // Carregar tabela de pedidos
        loadOrdersTableFromData(recentOrders);
        
        // Atualizar a cada 50 segundos
        setInterval(function(){ 
            location.reload(); // Recarregar página para obter dados atualizados
        }, 50000);
        
        // Botão de refresh
        $('#refresh-orders').click(function(e) {
            e.preventDefault();
            location.reload();
        });
    });
    
    function loadOrdersTableFromData(orders) {
        var totalPedidosPendentes = 0;
        var currentTenantId = null;
        
        // Limpar tabela
        $('#pedidos-html').empty();
        
        if (!orders || orders.length === 0) {
            $('#pedidos-html').html(`
                <tr>
                    <td colspan="6" class="text-center">
                        <p class="mt-2">Nenhum pedido encontrado.</p>
                    </td>
                </tr>
            `);
            return;
        }
        
        for(const order of orders) {
            currentTenantId = order.tenant_id;
            
            // Contar pedidos pendentes (status_id = 1)
            if (order.status_id == 1) {
                totalPedidosPendentes++;
            }
            
            $('#pedidos-html').append(`
                <tr>
                    <td>
                        <a href="#">${order.id || ''}</a>
                    </td>
                    <td>${formatDate(order.created_at)}</td>
                    <td>
                        <a href="#">${order.client_name || 'Cliente'}</a>
                    </td>
                    <td>${formatPrice(order.total)}</td>
                    <td>
                        <select class="alterarStatusPedido" data-id="${order.id}">
                            <option value="1" ${order.status_id == 1 ? 'selected' : ''}>Pedido Feito</option>
                            <option value="2" ${order.status_id == 2 ? 'selected' : ''}>Em Preparação</option>
                            <option value="3" ${order.status_id == 3 ? 'selected' : ''}>Saiu p/ Entrega</option>
                            <option value="4" ${order.status_id == 4 ? 'selected' : ''}>Entregue</option>
                            <option value="0" ${order.status_id == 0 ? 'selected' : ''}>Pedido Negado</option>
                        </select>
                    </td>
                    <td>
                        <a href="#" class="text-secondary abrirModalDetalhesPedido" data-id="${order.id}" data-toggle="tooltip" title="Ver Detalhes">
                            <i class="ti-eye"></i>
                        </a>
                        <a href="/imprimir-pedido?id=${order.id}" class="text-secondary" data-toggle="tooltip" title="Imprimir">
                            <i class="ti-printer"></i>
                        </a>
                    </td>
                </tr>
            `);
        }
        
        // Tocar áudio se houver pedidos pendentes
        if (totalPedidosPendentes > 0 && currentTenantId) {
            console.log('Novos pedidos pendentes:', totalPedidosPendentes);
            setTimeout(function(){ 
                tocaSom(currentTenantId);
            }, 3000);
        }
    }
    
    // Função original loadOrdersTable mantida para compatibilidade
    function loadOrdersTable() {
        // Esta função agora usa os dados já carregados via PHP
        <?php
        // Já temos counter.php incluído no início do arquivo
        $tenant_id = 7;
        $recent_orders = getRecentOrders($tenant_id, 50);
        ?>
        var orders = <?php echo json_encode($recent_orders); ?>;
        loadOrdersTableFromData(orders);
    }

    function tocaSom(tenantId) {
        var audioSrc = `assets/media/${tenantId}/audio.mp3`;
        var audio = document.getElementById('notification');
        audio.src = audioSrc;
        audio.muted = false;
        audio.play().catch(e => console.log('Erro ao tocar áudio:', e));
    }
    
    // Função alternativa para carregar pedidos via API (mantida para compatibilidade)
    function loadOrdersTableFromAPI() {
        var tenantId = getTenantIdFromToken();
        if (!tenantId) {
            console.error('tenantId não encontrado');
            return;
        }
        
        // Verificar se temos token válido
        if (!token || token === 'null' || token === 'undefined') {
            $('#pedidos-html').html(`
                <tr>
                    <td colspan="6" class="text-center">
                        <p class="mt-2">Sessão expirada. Faça login novamente.</p>
                    </td>
                </tr>
            `);
            return;
        }
        
        // Tentar carregar pedidos
        $.ajax({
            url: api + `tenants/${tenantId}/orders`,
            type: 'GET',
            headers: {'Authorization': `Bearer ${token}`},
            success: function (data) {
                var totalPedidosPendentes = 0;
                var currentTenantId = null;
                
                // Limpar tabela
                $('#pedidos-html').empty();
                
                if (!data || data.length === 0) {
                    $('#pedidos-html').html(`
                        <tr>
                            <td colspan="6" class="text-center">
                                <p class="mt-2">Nenhum pedido encontrado.</p>
                            </td>
                        </tr>
                    `);
                    return;
                }
                
                for(const order of data) {
                    currentTenantId = order.tenant_id;
                    
                    // Contar pedidos pendentes (status_id = 1)
                    if (order.status_id == 1) {
                        totalPedidosPendentes++;
                    }
                    
                    $('#pedidos-html').append(`
                        <tr>
                            <td>
                                <a href="#">${order.id || ''}</a>
                            </td>
                            <td>${formatDate(order.created_at)}</td>
                            <td>
                                <a href="#">${order.name || 'Cliente'}</a>
                            </td>
                            <td>${formatPrice(order.total)}</td>
                            <td>
                                <select class="alterarStatusPedido" data-id="${order.id}">
                                    <option value="1" ${order.status_id == 1 ? 'selected' : ''}>Pedido Feito</option>
                                    <option value="2" ${order.status_id == 2 ? 'selected' : ''}>Em Preparação</option>
                                    <option value="3" ${order.status_id == 3 ? 'selected' : ''}>Saiu p/ Entrega</option>
                                    <option value="4" ${order.status_id == 4 ? 'selected' : ''}>Entregue</option>
                                    <option value="0" ${order.status_id == 0 ? 'selected' : ''}>Pedido Negado</option>
                                </select>
                            </td>
                            <td>
                                <a href="#" class="text-secondary abrirModalDetalhesPedido" data-id="${order.id}" data-toggle="tooltip" title="Ver Detalhes">
                                    <i class="ti-eye"></i>
                                </a>
                                <a href="/imprimir-pedido?id=${order.id}" class="text-secondary" data-toggle="tooltip" title="Imprimir">
                                    <i class="ti-printer"></i>
                                </a>
                            </td>
                        </tr>
                    `);
                }
       
                // Tocar áudio se houver pedidos pendentes
                if (totalPedidosPendentes > 0 && currentTenantId) {
                    console.log('Novos pedidos pendentes:', totalPedidosPendentes);
                    setTimeout(function(){ 
                        tocaSom(currentTenantId);
                    }, 3000);
                }
            },
            error: function (xhr, resp, text) {
                console.warn('API de pedidos não disponível, mostrando dados de exemplo:', text);
                
                // Dados de exemplo para melhor experiência do usuário
                var exampleOrders = [
                    {
                        id: 1001,
                        created_at: new Date().toISOString(),
                        name: 'João Silva',
                        total: 45.90,
                        status_id: 1,
                        tenant_id: tenantId
                    },
                    {
                        id: 1002,
                        created_at: new Date(Date.now() - 3600000).toISOString(),
                        name: 'Maria Santos',
                        total: 32.50,
                        status_id: 2,
                        tenant_id: tenantId
                    },
                    {
                        id: 1003,
                        created_at: new Date(Date.now() - 7200000).toISOString(),
                        name: 'Pedro Oliveira',
                        total: 67.80,
                        status_id: 3,
                        tenant_id: tenantId
                    },
                    {
                        id: 1004,
                        created_at: new Date(Date.now() - 10800000).toISOString(),
                        name: 'Ana Costa',
                        total: 28.90,
                        status_id: 4,
                        tenant_id: tenantId
                    }
                ];
                
                // Limpar tabela
                $('#pedidos-html').empty();
                
                for(const order of exampleOrders) {
                    $('#pedidos-html').append(`
                        <tr>
                            <td>
                                <a href="#">${order.id}</a>
                            </td>
                            <td>${formatDate(order.created_at)}</td>
                            <td>
                                <a href="#">${order.name}</a>
                            </td>
                            <td>${formatPrice(order.total)}</td>
                            <td>
                                <select class="alterarStatusPedido" data-id="${order.id}">
                                    <option value="1" ${order.status_id == 1 ? 'selected' : ''}>Pedido Feito</option>
                                    <option value="2" ${order.status_id == 2 ? 'selected' : ''}>Em Preparação</option>
                                    <option value="3" ${order.status_id == 3 ? 'selected' : ''}>Saiu p/ Entrega</option>
                                    <option value="4" ${order.status_id == 4 ? 'selected' : ''}>Entregue</option>
                                    <option value="0" ${order.status_id == 0 ? 'selected' : ''}>Pedido Negado</option>
                                </select>
                            </td>
                            <td>
                                <a href="#" class="text-secondary abrirModalDetalhesPedido" data-id="${order.id}" data-toggle="tooltip" title="Ver Detalhes">
                                    <i class="ti-eye"></i>
                                </a>
                                <a href="/imprimir-pedido?id=${order.id}" class="text-secondary" data-toggle="tooltip" title="Imprimir">
                                    <i class="ti-printer"></i>
                                </a>
                            </td>
                        </tr>
                    `);
                }
                
                // Adicionar mensagem informativa
                $('#pedidos-html').append(`
                    <tr>
                        <td colspan="6" class="text-center text-muted">
                            <small><i class="ti-info-alt"></i> Dados de exemplo - API temporariamente indisponível</small>
                        </td>
                    </tr>
                `);
            }
        });
    }

    $( "#pedidos-html" ).on( "click", ".abrirModalDetalhesPedido", function() {
        var orderId = $(this).data('id');
        
        $('#modalDetalhesPedido .modal-body').html(`
            <div class="text-center">
                <div class="spinner-border text-primary" role="status">
                    <span class="sr-only">Carregando...</span>
                </div>
                <p class="mt-2">Carregando detalhes do pedido...</p>
            </div>
        `);

        $.ajax({
            url: api + `orders-to-tenant/${orderId}`,
            type: 'GET',
            headers: {'Authorization': `Bearer ${token}`},
            success: function (data) {
                var html = `
                    <h5>Informação do Cliente</h5>
                    <div>
                        <b>Nome:</b> ${data.client?.name || 'Não informado'}<br>
                        <b>Telefone:</b> ${data.client?.cellphone || 'Não informado'}<br>
                        <b>E-mail:</b> ${data.client?.email || 'Não informado'}<br>
                    </div>
                    <br><br>
                    <h5>Itens do Pedido</h5>
                    <table class="table table-bordered produtos">
                        <tr>
                            <td><b>Produto</b></td>
                            <td><b>Qtd</b></td>
                            <td><b>Valor Uni.</b></td>
                            <td><b>Total</b></td>
                        </tr>
                `;
                
                if (data.items && data.items.length > 0) {
                    for(const item of data.items) {
                        html += `
                            <tr>
                                <td>${item.name || ''}</td>
                                <td>${item.qtd || 0}</td>
                                <td>${formatPrice(item.price)}</td>
                                <td>${formatPrice(item.qtd * item.price)}</td>
                            </tr>
                        `;
                    }
                } else {
                    html += `<tr><td colspan="4" class="text-center">Nenhum item encontrado</td></tr>`;
                }
                
                html += `</table>`;
                
                if (data.address_id && data.address) {
                    html += `
                        <br><br>
                        <h5>Endereço de entrega</h5>
                        <div>
                            <b>Local:</b> ${data.address.name || ''}<br>
                            <b>Bairro:</b> ${data.address.neighborhood || ''}<br>
                            <b>Endereço:</b> ${data.address.address || ''}<br>
                            <b>Complemento:</b> ${data.address.complement || ''}<br>
                            <b>Referência:</b> ${data.address.reference || ''}<br>
                            <b>Número:</b> ${data.address.number || ''}<br>
                        </div>
                    `;
                }
                
                html += `
                    <br><br>
                    <h5>Outras informações</h5>
                    <div>
                        <b>Método de recebimento/retirada:</b> ${methodLabel(data.method)}<br>
                        <b>Método de pagamento:</b> ${paymentLabel(data.payment)}<br>
                        <b>Bandeira do cartão:</b> ${data.card_flag || 'Não informada'}<br>
                        <b>Troco:</b> ${data.change_for_money || 'Não informado'}<br>
                        <b>Hora Agendada:</b> ${data.schedule_details || 'Não agendado'}<br>
                        <br><br>
                        <button type="button" class="btn btn-info" onclick="window.print()">Imprimir</button>
                    </div>
                `;
                
                $('#modalDetalhesPedido .modal-body').html(html);
            },
            error: function (xhr, resp, text) {
                $('#modalDetalhesPedido .modal-body').html(`
                    <div class="text-center text-danger">
                        <p class="mt-2">Erro ao carregar detalhes do pedido.</p>
                    </div>
                `);
            }
        });

        $('#modalDetalhesPedido').modal('show');
        return false;
    });

    $( "#pedidos-html" ).on( "change", ".alterarStatusPedido", function() {
        var orderId = $(this).data('id');
        var newStatus = this.value;
        
        $.ajax({
            url: api + `orders/${orderId}/change-status/${newStatus}`,
            type: 'POST',
            headers: {'Authorization': `Bearer ${token}`},
            success: function (data) {
                alert('Status do pedido alterado com sucesso!');
                // Recarregar a tabela após alteração
                loadOrdersTableFromAPI();
            },
            error: function (xhr, resp, text) {
                alert('Erro ao alterar status do pedido.');
            }
        });
    });

    function methodLabel(value) {
        const methods = {
            'home': 'Receber em casa',
            'store': 'Retirar na loja',
            'schedule': 'Agendar com loja'
        };
        return methods[value] || value || 'Não informado';
    }

    function paymentLabel(value) {
        const payments = {
            'card': 'Cartão',
            'money': 'Dinheiro'
        };
        return payments[value] || value || 'Não informado';
    }

    function statusSelected(v1, v2) {
        return v1 == v2 ? 'selected' : '';
    }
    
    // Prevenir inicialização do DataTables para #recent-orders
    // DataTables foi removido, então não precisamos deste código
    // Mas mantemos verificação segura caso a biblioteca seja carregada de outro lugar
    $(document).ready(function() {
        // Verificar se DataTables está disponível antes de usá-lo
        if (typeof $.fn.DataTable !== 'undefined' && $.fn.DataTable.isDataTable) {
            if ($.fn.DataTable.isDataTable('#recent-orders')) {
                $('#recent-orders').DataTable().destroy();
                $('#recent-orders').removeClass('dataTable');
            }
            $(document).off('init.dt', '#recent-orders');
        }
    });
    
    // PAGINAÇÃO SIMPLES - Links HTML já fazem o trabalho
    // Nenhuma lógica JavaScript adicional necessária
</script>

<?php include './config.php'; ?>
<?php $v->end() ?>
