<?php 
// Habilitar logs de erro para diagnóstico
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);

require_once __DIR__ . "/../app/Helpers/counter.php"; 
?>
<?php $v->layout('layouts/main', ['title' => 'Painel Administrativo']) ?>

<?php 
// Obter dados reais com tratamento de erro
// As funções agora obtêm tenant_id automaticamente do token
try {
    $counters = getDashboardCounters(); // Sem parâmetro = usa token
    $recent_orders = getRecentOrders(null, 10); // null = usa token
    
    // Log para debug
    error_log("HOME: Dashboard counters: " . print_r($counters, true));
    error_log("HOME: Recent orders count: " . count($recent_orders));
    
} catch (Exception $e) {
    error_log("HOME: Erro ao obter dados do dashboard: " . $e->getMessage());
    $counters = array('orders' => 0, 'clients' => 0, 'couriers' => 0);
    $recent_orders = array();
}

// Garantir que os dados existam (sem operador ?? para compatibilidade)
$orders_count = isset($counters['orders']) ? $counters['orders'] : 0;
$clients_count = isset($counters['clients']) ? $counters['clients'] : 0;
$couriers_count = isset($counters['couriers']) ? $counters['couriers'] : 0;
$has_orders = !empty($recent_orders);
?>

<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
    /* Estilo para quando DataTables está desabilitado */
    .no-datatables table {
        width: 100%;
        border-collapse: collapse;
    }
    .no-datatables th {
        background-color: #f8f9fa;
        padding: 12px;
        text-align: left;
        border-bottom: 2px solid #dee2e6;
    }
    .no-datatables td {
        padding: 12px;
        border-bottom: 1px solid #dee2e6;
    }
</style>
<?php $v->end() ?>

<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item active">
                <a href="/dashboard">Dashboard</a>
            </li>
        </ol>
    </nav>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="row">
            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Pedido</p>
                                <h2 class="font-weight-bold"><?php echo $orders_count; ?></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-success-bright text-success rounded-circle">
                                        <i class="fas fa-shopping-cart"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Clientes</p>
                                <h2 class="font-weight-bold"><?php echo $clients_count; ?></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-info-bright text-info rounded-circle">
                                        <i class="fas fa-users"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Entregadores</p>
                                <h2 class="font-weight-bold"><?php echo $couriers_count; ?></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-secondary-bright text-secondary rounded-circle">
                                        <i class="fas fa-truck"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <div class="col-lg-3 col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <div>
                                <p class="text-muted">Estabelecimentos</p>
                                <h2 class="font-weight-bold"><?php echo getEstablishmentCount(); ?></h2>
                            </div>
                            <div>
                                <figure class="avatar">
                                    <span class="avatar-title bg-warning-bright text-warning rounded-circle">
                                        <i class="fas fa-store"></i>
                                    </span>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Pedidos recentes</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" id="refresh-orders">
                    <i class="fa fa-refresh"></i>
                </a>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive <?php echo $has_orders ? '' : 'no-datatables'; ?>">
                    <table id="recent-orders" class="table table-lg">
                        <thead>
                            <tr>
                                <th>#ID</th>
                                <th>Data</th>
                                <th>Nome</th>
                                <th>Preço</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody id="pedidos-html">
                            <?php if ($has_orders): ?>
                                <?php foreach ($recent_orders as $order): ?>
                                <tr>
                                    <td>
                                        <a href="#"><?php echo htmlspecialchars(isset($order['id']) ? $order['id'] : ''); ?></a>
                                    </td>
                                    <td><?php echo date('d/m/Y H:i', strtotime(isset($order['created_at']) ? $order['created_at'] : '')); ?></td>
                                    <td>
                                        <a href="#"><?php echo htmlspecialchars(isset($order['client_name']) ? $order['client_name'] : 'Cliente'); ?></a>
                                    </td>
                                    <td>R$ <?php echo number_format(isset($order['total']) ? $order['total'] : 0, 2, ',', '.'); ?></td>
                                    <td>
                                        <?php
                                        $status_id = isset($order['status_id']) ? $order['status_id'] : 0;
                                        $status_class = '';
                                        $status_text = '';
                                        
                                        switch($status_id) {
                                            case 1: 
                                                $status_class = 'badge-warning';
                                                $status_text = 'Pedido Feito';
                                                break;
                                            case 2: 
                                                $status_class = 'badge-info';
                                                $status_text = 'Em Preparação';
                                                break;
                                            case 3: 
                                                $status_class = 'badge-primary';
                                                $status_text = 'Saiu p/ Entrega';
                                                break;
                                            case 4: 
                                                $status_class = 'badge-success';
                                                $status_text = 'Entregue';
                                                break;
                                            case 0: 
                                                $status_class = 'badge-secondary';
                                                $status_text = 'Pedido Negado';
                                                break;
                                            default:
                                                $status_class = 'badge-secondary';
                                                $status_text = 'Desconhecido';
                                        }
                                        ?>
                                        <span class="badge <?php echo $status_class; ?>"><?php echo $status_text; ?></span>
                                    </td>
                                    <td>
                                        <a href="#" class="text-secondary" data-toggle="tooltip" title="Ver Detalhes">
                                            <i class="ti-eye"></i>
                                        </a>
                                        <a href="/imprimir-pedido?id=<?php echo isset($order['id']) ? $order['id'] : ''; ?>" class="text-secondary ml-2" data-toggle="tooltip" title="Imprimir">
                                            <i class="ti-printer"></i>
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" class="text-center">
                                        <div class="alert alert-info">
                                            <i class="ti-info-alt"></i> Nenhum pedido encontrado para seu tenant.
                                            <br><small>Isso pode ocorrer se: 1) Não houver pedidos, 2) Token inválido, 3) API offline</small>
                                        </div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $v->start('scripts') ?>
<script src="assets/js/examples/pages/ecommerce-dashboard.js"></script>
<script src="apexcharts.com/samples/assets/irregular-data-series.js"></script>
<script src="vendors/charts/apex/apexcharts.min.js"></script>
<script src="vendors/dataTable/datatables.min.js"></script>

<script>
$(document).ready(function() {
    // Botão de refresh simples
    $('#refresh-orders').click(function(e) {
        e.preventDefault();
        location.reload();
    });
    
    // Inicializar DataTables APENAS se houver dados e a biblioteca existir
    var $table = $('#recent-orders');
    var hasData = $table.find('tbody tr:not(.text-center)').length > 0;
    
    if (hasData && $.fn.DataTable) {
        try {
            $table.DataTable({
                "pageLength": 10,
                "order": [[1, 'desc']],
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Portuguese-Brasil.json"
                }
            });
            console.log('DataTables inicializado com sucesso');
        } catch (e) {
            console.error('Erro ao inicializar DataTables:', e);
        }
    } else {
        console.log('DataTables não inicializado: ' + (hasData ? 'sem dados' : 'biblioteca não disponível'));
    }
});
</script>
<?php $v->end() ?>

<!-- Debug info (apenas se houver erro) -->
<?php if (error_get_last()): ?>
<div style="display:none;">
    <pre><?php print_r(error_get_last()); ?></pre>
</div>
<?php endif; ?>
