<?php $v->layout('layouts/main', ['title' => 'Entregas']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Entregas por Bairro</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Entregas</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadEntrega">
                    <i class="fa fa-plus"></i> &nbsp; Novo Valor de Entrega
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="neighborhoods" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Bairro</th>
                                <th>Taxa de Entrega</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR BAIRRO -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadEntrega">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Entrega por Bairro</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarEntrega">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Bairro</label>
                                <input type="text" class="form-control" name="name" placeholder="Bairro" maxlength="30">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="value">Valor</label>
                                <input type="text" class="form-control value" name="value" placeholder="Valor da Entrega" data-affixes-stay="false" data-thousands="." data-decimal="," maxlength="12">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadEntrega">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR BAIRRO -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditEntrega">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Entrega por Bairro</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarEntrega">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" id="id_neighborhood">
                                <label for="name">Bairro</label>
                                <input type="text" class="form-control" name="name" placeholder="Bairro" maxlength="30" id="name_neighborhood">
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="value">Valor</label>
                                <input type="text" class="form-control value" name="value" placeholder="Valor da Entrega" data-affixes-stay="false" data-thousands="." data-decimal="," maxlength="12" id="value_neighborhood">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditEntrega">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-maskmoney/3.0.2/jquery.maskMoney.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };

    // carregar a tabela de entregas
    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#components_e > a').addClass("active");
        $('div#components').addClass("open");
        $('a#bairros').addClass("active");
        

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#neighborhoods').DataTable({
            "ajax": {
                "url": api + "neighborhoods",
                "type": 'GET',
                "headers": {'X-Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": "name"},
                {"data": "value"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                },
            ]
        });
    });


    $(document).ready(function () {

        // mascara valor
        $(".value").maskMoney();


        // cadastrar o entrega
        $(document).on('click', '#btnCadEntrega', function () {

            // get form data
            var form_data = $('#frmCadastrarEntrega').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "neighborhoods",
                type: 'POST',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Valor da Entrega cadastrado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarEntrega').trigger("reset");
                    $('#modalCadEntrega').modal('hide');
                    $('#neighborhoods').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditEntrega').on('hidden.bs.modal', function () {
            $('#frmEditarEntrega input').each(function () {
                $(this).val('');
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "neighborhoods/" + item_id,
                type: 'GET',
                headers: {"X-Authorization": `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_neighborhood').val(data.id);
                    $('#name_neighborhood').val(data.name);
                    $('#value_neighborhood').val(data.value);

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditEntrega').modal('show');
        });


        // editar o entrega
        $(document).on('click', '#btnEditEntrega', function () {

            var id = $('#id_neighborhood').val();
            var form_data = $('#frmEditarEntrega').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "neighborhoods/" + id,
                type: 'PUT',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Valor da Entrega alterado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarEntrega').trigger("reset");
                    $('#modalEditEntrega').modal('hide');
                    $('#neighborhoods').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });



        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar este valor de entrega?');
            if (confirmado) {

                $.ajax({
                    url: api + "neighborhoods/" + item_id,
                    type: 'DELETE',
                    headers: {"X-Authorization": `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Valor da Entrega excluído com sucesso!',
                            timeout: 6000,
                        });

                        $('#neighborhoods').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });

    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>