<?php $v->layout('layouts/main', ['title' => 'Pagamentos']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Pagamentos</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Pagamentos</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadPagamento">
                    <i class="fa fa-plus"></i> &nbsp; Novo Pagamento
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="payments" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Pagamento</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR PAGAMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadPagamento">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Pagamento</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarPagamento">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="gateway_payment_id">Forma de Pagamento</label>
                                <select class="form-control gatewayPayments" name="gateway_payment_id" style="width: 100%;" required='required'>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="limit_parcel">Parcelar em até:</label>
                                <select class="form-control" name="limit_parcel" style="width: 100%;" required='required'>
                                    <option value="1">Somente à vista</option>
                                    <option value="2">02 vezes</option>
                                    <option value="3">03 vezes</option>
                                    <option value="4">04 vezes</option>
                                    <option value="5">05 vezes</option>
                                    <option value="6">06 vezes</option>
                                    <option value="7">07 vezes</option>
                                    <option value="8">08 vezes</option>
                                    <option value="9">09 vezes</option>
                                    <option value="10">10 vezes</option>
                                    <option value="11">11 vezes</option>
                                    <option value="12">12 vezes</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="limit_parcel_interest_free">Parcela sem Juros:</label>
                                <select class="form-control" name="limit_parcel_interest_free" style="width: 100%;" required='required'>
                                    <option value="2">02 vezes</option>
                                    <option value="3">03 vezes</option>
                                    <option value="4">04 vezes</option>
                                    <option value="5">05 vezes</option>
                                    <option value="6">06 vezes</option>
                                    <option value="7">07 vezes</option>
                                    <option value="8">08 vezes</option>
                                    <option value="9">09 vezes</option>
                                    <option value="10">10 vezes</option>
                                    <option value="11">11 vezes</option>
                                    <option value="12">12 vezes</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="discount_slip">Desconto no boleto de:</label>
                                <input type="number" class="form-control name" name="discount_slip" min="1" max="100">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadPagamento">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR PAGAMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditPagamento">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Pagamento</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarPagamento">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" id="id_payment">
                                <label for="gateway_payment_id">Forma de Pagamento</label>
                                <select class="form-control gatewayPayments" name="gateway_payment_id" style="width: 100%;" required='required' id="gateway_payment_id_payment">
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="limit_parcel">Parcelar em até:</label>
                                <select class="form-control" name="limit_parcel" style="width: 100%;" required='required' id="limit_parcel_payment">
                                    <option value="1">Somente à vista</option>
                                    <option value="2">02 vezes</option>
                                    <option value="3">03 vezes</option>
                                    <option value="4">04 vezes</option>
                                    <option value="5">05 vezes</option>
                                    <option value="6">06 vezes</option>
                                    <option value="7">07 vezes</option>
                                    <option value="8">08 vezes</option>
                                    <option value="9">09 vezes</option>
                                    <option value="10">10 vezes</option>
                                    <option value="11">11 vezes</option>
                                    <option value="12">12 vezes</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="limit_parcel_interest_free">Parcela sem Juros:</label>
                                <select class="form-control" name="limit_parcel_interest_free" style="width: 100%;" required='required' id="limit_parcel_interest_free_payment">
                                    <option value="2">02 vezes</option>
                                    <option value="3">03 vezes</option>
                                    <option value="4">04 vezes</option>
                                    <option value="5">05 vezes</option>
                                    <option value="6">06 vezes</option>
                                    <option value="7">07 vezes</option>
                                    <option value="8">08 vezes</option>
                                    <option value="9">09 vezes</option>
                                    <option value="10">10 vezes</option>
                                    <option value="11">11 vezes</option>
                                    <option value="12">12 vezes</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="discount_slip">Desconto no boleto de:</label>
                                <input type="number" class="form-control name" name="discount_slip" min="1" max="100" id="discount_slip_payment">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditPagamento">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };

    // carregar a tabela de gateway
    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#components_e > a').addClass("active");
        $('div#components').addClass("open");
        $('a#pagamentos').addClass("active");
        
        

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#payments').DataTable({
            "ajax": {
                "url": api + "payments",
                "type": 'GET',
                "headers": {'X-Authorization': `Bearer ${token}`},
                "dataSrc": "",
            },
            "columns": [
                {"data": "gateway_payment.name"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                },
            ]
        });

        // carregar select na modal
        selectGatewayPayment();
    });


    $(document).ready(function () {

        // cadastrar o gateway
        $(document).on('click', '#btnCadPagamento', function () {

            // get form data
            var form_data = $('#frmCadastrarPagamento').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "payments",
                type: 'POST',
                headers: {'Authorization': `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Pagamento cadastrado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarPagamento').trigger("reset");
                    $('#modalCadPagamento').modal('hide');
                    $('#payments').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditPagamento').on('hidden.bs.modal', function () {
            $('#frmEditarPagamento input').each(function () {
                $(this).val('');
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "payments/" + item_id,
                type: 'GET',
                headers: {'Authorization': `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_payment').val(data.id);
                    $('#gateway_payment_id_payment').val(data.gateway_payment_id);
                    $('#limit_parcel_payment').val(data.limit_parcel);
                    $('#limit_parcel_interest_free_payment').val(data.limit_parcel_interest_free);
                    $('#discount_slip_payment').val(data.discount_slip);

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditPagamento').modal('show');
        });


        // editar o pagamento
        $(document).on('click', '#btnEditPagamento', function () {

            var id = $('#id_payment').val();
            var form_data = $('#frmEditarPagamento').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // carregar select na modal
            selectGatewayPayment();

            // submit form data to api
            $.ajax({
                url: api + "payments/" + id,
                type: 'PUT',
                headers: {'Authorization': `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Pagamento alterado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarPagamento').trigger("reset");
                    $('#modalEditPagamento').modal('hide');
                    $('#payments').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar esta forma de pagamento?');
            if (confirmado) {

                $.ajax({
                    url: api + "payments/" + item_id,
                    type: 'DELETE',
                    headers: {'Authorization': `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Pagamento excluído com sucesso!',
                            timeout: 6000,
                        });

                        $('#payments').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });

    });




    // select
    function selectGatewayPayment()
    {
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
        var api = '<?php echo API; ?>';

        $.ajax({
            type: 'GET',
            url: api + "gateways",
            headers: {'Authorization': `Bearer ${token}`},
            success: function (data) {
                gatewayPayments = JSON.parse(JSON.stringify(data));

                $(".gatewayPayments").html('');
                $.each(gatewayPayments, function (i, gatewayPayment) {
                    $(".gatewayPayments").append($('<option>', {
                        value: gatewayPayment.id, //Id do objeto segmento
                        text: gatewayPayment.name //Nome do segmento
                    }));
                });
            }
        });
    }
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>