<?php $v->layout('layouts/main', ['title' => 'Segmentos']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Segmentos</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Segmentos</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadSegmento">
                    <i class="fa fa-plus"></i> &nbsp; Novo Segmento
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="segments" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Segmento</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR SEGMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadSegmento">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Segmento</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarSegmento">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Segmento</label>
                                <input type="text" class="form-control" name="name" placeholder="Segmento" maxlength="30">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadSegmento">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR SEGMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditSegmento">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Segmento</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarSegmento">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" id="id_segment">
                                <label for="name">Segmento</label>
                                <input type="text" class="form-control" name="name" placeholder="Segmento" maxlength="30" id="name_segment">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditSegmento">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"A"') {
            return logout();
        }
    };

    // carregar a tabela de segmentos
    $(window).on('load', function () {

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#segments').DataTable({
            "ajax": {
                "url": api + "segments",
                "type": 'GET',
                "headers": {'X-Authorization': `Bearer ${token}`},
                "dataSrc": ""
            },
            "columns": [
                {"data": "name"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                },
            ]
        });
    });


    $(document).ready(function () {
    
    // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#analytics_a > a').addClass("active");
        $('div#analytics').addClass("open");
        $('a#segmentos').addClass("active");
    

        // cadastrar o segmento
        $(document).on('click', '#btnCadSegmento', function () {

            // get form data
            var form_data = $('#frmCadastrarSegmento').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "segments",
                type: 'POST',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Segmento cadastrado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarSegmento').trigger("reset");
                    $('#modalCadSegmento').modal('hide');
                    $('#segments').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditSegmento').on('hidden.bs.modal', function () {
            $('#frmEditarSegmento input').each(function () {
                $(this).val('');
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "segments/" + item_id,
                type: 'GET',
                headers: {"X-Authorization": `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_segment').val(data.id);
                    $('#name_segment').val(data.name);

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditSegmento').modal('show');
        });


        // editar o segmento
        $(document).on('click', '#btnEditSegmento', function () {

            var id = $('#id_segment').val();
            var form_data = $('#frmEditarSegmento').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "segments/" + id,
                type: 'PUT',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Segmento alterado com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarSegmento').trigger("reset");
                    $('#modalEditSegmento').modal('hide');
                    $('#segments').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar esta forma de segmento?');
            if (confirmado) {

                $.ajax({
                    url: api + "segments/" + item_id,
                    type: 'DELETE',
                    headers: {"X-Authorization": `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Segmento excluído com sucesso!',
                            timeout: 6000,
                        });

                        $('#segments').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });

    });
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>