<?php $v->layout('layouts/main', ['title' => 'Subcategorias']) ?>


<?php $v->start('styles') ?>
<link rel="stylesheet" href="vendors/dataTable/datatables.min.css" type="text/css">
<style>
    body {
        margin-bottom: 50px;
    }
</style>
<?php $v->end() ?>



<div class="page-header">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="/dashboard">Dashboard</a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">Subcategorias</li>
        </ol>
    </nav>
</div>

<div class="card">
    <div class="card-body">
        <div class="d-flex justify-content-between">
            <h6 class="card-title">Subcategorias</h6>
            <div>
                <a href="#" class="btn btn-outline-light btn-sm mr-2" data-toggle="modal" data-target="#modalCadSubcategoria">
                    <i class="fa fa-plus"></i> &nbsp; Nova Subcategoria
                </a>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="subcategories" class="table table-lg">
                        <thead>
                            <tr>
                                <th>Subcategoria</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- CADASTRAR PAGAMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalCadSubcategoria">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cadastrar Subcategoria</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmCadastrarSubcategoria">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" id="id_subcategory">
                                <label for="category_id">Categoria</label>
                                <select class="form-control categories" name="category_id" style="width: 100%;" required='required'>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Subcategoria</label>
                                <input type="text" class="form-control" name="name" placeholder="Subcategoria" required="" maxlength="50">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnCadSubcategoria">Cadastrar</button>
                </div>
            </form>
        </div>
    </div>
</div>


<!-- EDITAR PAGAMENTO -->
<div class="modal" tabindex="-1" role="dialog" id="modalEditSubcategoria">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Subcategoria</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <form id="frmEditarSubcategoria">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="hidden" id="id_subcategory">
                                <label for="category_id">Categoria</label>
                                <select class="form-control categories" name="category_id" style="width: 100%;" required='required' id="category_id_subcategory">
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">Subcategoria</label>
                                <input type="text" class="form-control" name="name" placeholder="Subcategoria" required="" maxlength="50" id="name_subcategory">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="button" class="btn btn-primary" id="btnEditSubcategoria">Editar</button>
                </div>
            </form>
        </div>
    </div>
</div>




<?php $v->start('scripts') ?>
<script src="vendors/dataTable/datatables.min.js"></script>
<script>
    // retorna para o login se não tiver acesso a essa página
    window.onload = function () {
        var data = sessionStorage.getItem('Me');
        if (data != '"E"') {
            return logout();
        }
    };

    // carregar a tabela de subcategorias
    $(window).on('load', function () {
        
        // MENU MARCAR
        $('li#ecommerce_a > a').removeClass("active");
        $('div#ecommerce').removeClass("open");
        $('a#dashboard').removeClass("active");        
        
        $('li#components_e > a').addClass("active");
        $('div#components').addClass("open");
        $('a#subcategorias').addClass("active");
        
        

        var api = '<?php echo API; ?>';
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));

        $('#subcategories').DataTable({
            "ajax": {
                "url": api + "subcategories",
                "type": 'GET',
                "headers": {'X-Authorization': `Bearer ${token}`},
                "dataSrc": "",
            },
            "columns": [
                {"data": "name"},
                {"data": 'id',
                    "render": function (data, type, row, meta) {
                        return '<a href="" type="button" class="text-secondary" data-toggle="tooltip" name="editItem" data-item_id=' + data + ' title="Editar"><i class="ti-pencil"></i></a> <a href="" type="button" class="text-danger ml-2 form-delete-item" data-toggle="tooltip"  name="deleteItem" data-item_id=' + data + ' title="Deletar"><i class="ti-trash"></i></a>'
                    }
                },
            ]
        });

        // carregar select na modal
        selectCategories();
    });


    $(document).ready(function () {

        // cadastrar o gateway
        $(document).on('click', '#btnCadSubcategoria', function () {

            // get form data
            var form_data = $('#frmCadastrarSubcategoria').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "subcategories",
                type: 'POST',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Subcategoria cadastrada com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmCadastrarSubcategoria').trigger("reset");
                    $('#modalCadSubcategoria').modal('hide');
                    $('#subcategories').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // limpar a modal ao fechar
        $('#modalEditSubcategoria').on('hidden.bs.modal', function () {
            $('#frmEditarSubcategoria input').each(function () {
                $(this).val('');
            });
        });


        // carregar o item na modal edit
        $(document).on('click', '[name="editItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // submit form data to api
            $.ajax({
                url: api + "subcategories/" + item_id,
                type: 'GET',
                headers: {"X-Authorization": `Bearer ${token}`},
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));

                    $('#id_subcategory').val(data.id);
                    $('#category_id_subcategory').val(data.category_id);
                    $('#name_subcategory').val(data.name);

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });

            $('#modalEditSubcategoria').modal('show');
        });


        // editar o pagamento
        $(document).on('click', '#btnEditSubcategoria', function () {

            var id = $('#id_subcategory').val();
            var form_data = $('#frmEditarSubcategoria').serialize();
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            // carregar select na modal
            selectCategories();

            // submit form data to api
            $.ajax({
                url: api + "subcategories/" + id,
                type: 'PUT',
                headers: {"X-Authorization": `Bearer ${token}`},
                data: form_data,
                success: function (data) {
                    var data = JSON.parse(JSON.stringify(data));
                    iziToast.success({
                        position: 'bottomRight',
                        title: 'OK',
                        message: 'Subcategoria alterada com sucesso!',
                        timeout: 6000,
                    });

                    $('#frmEditarSubcategoria').trigger("reset");
                    $('#modalEditSubcategoria').modal('hide');
                    $('#subcategories').DataTable().ajax.reload();

                },
                error: function (xhr, resp, text) {
                    console.log('deu ruim');

                }
            });
        });


        // deletar item
        $(document).on('click', '[name="deleteItem"]', function (e) {
            e.preventDefault();

            var item_id = $(this).data('item_id');
            var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
            var api = '<?php echo API; ?>';

            var confirmado = confirm('Deseja realmente deletar esta subcategoria?');
            if (confirmado) {

                $.ajax({
                    url: api + "subcategories/" + item_id,
                    type: 'DELETE',
                    headers: {"X-Authorization": `Bearer ${token}`},
                    success: function (data) {

                        iziToast.success({
                            position: 'bottomRight',
                            title: 'OK',
                            message: 'Subcategoria excluída com sucesso!',
                            timeout: 6000,
                        });

                        $('#subcategories').DataTable().ajax.reload();

                    },
                    error: function (xhr, resp, text) {
                        console.log('deu ruim');

                    }
                });

            } else {
                return false;
            }

        });

    });




    // select
    function selectCategories()
    {
        var token = JSON.parse(sessionStorage.getItem('MyUniqueUserToken'));
        var api = '<?php echo API; ?>';

        $.ajax({
            type: 'GET',
            url: api + "categories",
            headers: {"X-Authorization": `Bearer ${token}`},
            success: function (data) {
                categories = JSON.parse(JSON.stringify(data));

                $(".categories").html('');
                $.each(categories, function (i, category) {
                    $(".categories").append($('<option>', {
                        value: category.id, //Id do objeto segmento
                        text: category.name //Nome da categoria
                    }));
                });
            }
        });
    }
</script>
<?php include './config.php'; ?>
<?php $v->end() ?>